/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.ServantEntityImpl;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModDamages;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFamiliarReceptacle
extends ItemGeneric
implements IDelayedNBTLoot {
    private static final String CAPTURABLE_TYPE_NBT_STRING = "capturable_type";
    private static final String DEAD_PET_NBT_COMPOUND = "dead_pet";

    public ItemFamiliarReceptacle() {
        super("familiar_receptacle", ItemFamiliarReceptacle.getBuilder().m_41487_(1).m_41486_(), () -> SharedConfigTombstone.allowed_magic_items.allowFamiliarReceptacle.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        CompoundTag pet_tag = this.getDeadPetTag(stack).orElse(null);
        if (pet_tag == null) {
            this.addItemDesc(tooltip, "1", new Object[0]);
            String id = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING);
            if (!id.isEmpty()) {
                tooltip.add((Component)LangKey.MESSAGE_IMPREGNATE.getText(StyleType.MESSAGE_SPECIAL, new Object[]{LangKey.getEntityName(id)}));
            }
        } else if (pet_tag.m_128425_("id", 8)) {
            this.addItemDesc(tooltip, "2", LangKey.getEntityName(pet_tag.m_128461_("id")));
            this.addItemUse(tooltip, this.getDurabilityRatio(stack) == 0.0 ? "2" : "1", new Object[0]);
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.m_246342_(new ItemStack((ItemLike)this));
        }
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        if (EntityHelper.isValidServerPlayer(player) && !NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING).isEmpty()) {
            ModTriggers.IMPREGNATED_RECEPTACLE.trigger((ServerPlayer)player);
        }
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.containSoul(stack) || super.m_5812_(stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && stack.m_150930_((Item)this) && EntityHelper.isValidPlayer(entity) && TimeHelper.atInterval(entity, TimeHelper.tickFromSecond(30))) {
            this.getDeadPetTag(stack).ifPresent(pet_tag -> {
                float maxHealth;
                float health = pet_tag.m_128425_("Health", 5) ? Math.max(0.0f, pet_tag.m_128457_("Health")) : 1.0f;
                float f = maxHealth = pet_tag.m_128425_("max_life", 5) ? Math.max(1.0f, pet_tag.m_128457_("max_life")) : 1.0f;
                if (health < maxHealth) {
                    float gain = maxHealth * 0.1f;
                    Player player = (Player)entity;
                    pet_tag.m_128350_("Health", Math.min(health + Math.min(player.m_21223_(), gain), maxHealth));
                    if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue()) {
                        player.m_6469_(ModDamages.sourceBeyondTheGrave((Entity)player), gain);
                    }
                }
            });
        }
    }

    public double getDurabilityRatio(ItemStack stack) {
        return this.getDeadPetTag(stack).map(pet_tag -> {
            float health = pet_tag.m_128425_("Health", 5) ? Math.max(0.0f, pet_tag.m_128457_("Health")) : 1.0f;
            float maxHealth = pet_tag.m_128425_("max_life", 5) ? Math.max(1.0f, pet_tag.m_128457_("max_life")) : 1.0f;
            return 1.0 - (double)health / (double)maxHealth;
        }).orElse(1.0);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.containSoul(stack) && this.getDurability(stack) > 0.0;
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)(1.0 - this.getDurability(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)this.getDurability(stack) * 13.0f);
    }

    public double getDurability(ItemStack stack) {
        return this.getDeadPetTag(stack).map(pet_tag -> {
            float health = pet_tag.m_128425_("Health", 5) ? Math.max(0.0f, pet_tag.m_128457_("Health")) : 1.0f;
            float maxHealth = pet_tag.m_128425_("max_life", 5) ? Math.max(1.0f, pet_tag.m_128457_("max_life")) : 1.0f;
            return 1.0 - (double)health / (double)maxHealth;
        }).orElse(1.0);
    }

    public boolean containSoul(ItemStack stack) {
        return stack.m_150930_((Item)this) && stack.m_41783_() != null && stack.m_41783_().m_128425_(DEAD_PET_NBT_COMPOUND, 10);
    }

    private Optional<CompoundTag> getDeadPetTag(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_()).filter(tag -> tag.m_128425_(DEAD_PET_NBT_COMPOUND, 10)).map(tag -> tag.m_128469_(DEAD_PET_NBT_COMPOUND));
    }

    public boolean revive(Player player, BlockPos gravePos, ItemStack stack, boolean unequip) {
        return this.getDeadPetTag(stack).map(pet_tag -> pet_tag.m_128425_("id", 8) && EntityType.m_20632_((String)pet_tag.m_128461_("id")).map(entityType -> {
            LivingEntity entity = (LivingEntity)entityType.m_20615_(player.m_9236_());
            if (entity == null) {
                return false;
            }
            if (pet_tag.m_128441_("is_spellcaster")) {
                entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> cap.setSpellCaster(ServantEntityImpl.CasterType.getRandomId()));
            }
            if (pet_tag.m_128441_("max_life")) {
                pet_tag.m_128473_("max_life");
                entity.m_20258_(pet_tag);
                entity.m_6034_((double)gravePos.m_123341_() + 0.5, (double)gravePos.m_123342_() + 0.5, (double)gravePos.m_123343_() + 0.5);
            } else if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_6034_((double)gravePos.m_123341_() + 0.5, (double)gravePos.m_123342_() + 0.5, (double)gravePos.m_123343_() + 0.5);
                mob.m_6518_((ServerLevelAccessor)((ServerLevel)player.m_9236_()), player.m_9236_().m_6436_(entity.m_20183_()), MobSpawnType.TRIGGERED, null, null);
            }
            if (unequip) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    entity.m_8061_(slot, ItemStack.f_41583_);
                }
            }
            entity.m_21153_(entity.m_21233_());
            TameableType.setTamedBy(player, (Entity)entity);
            EffectHelper.clearBadEffects(entity);
            entity.m_19877_();
            player.m_9236_().m_7967_((Entity)entity);
            return true;
        }).orElse(false) != false).orElse(false);
    }

    public void setCapturableType(ItemStack stack, String type) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setString(stack, CAPTURABLE_TYPE_NBT_STRING, type);
        }
    }

    private boolean canCaptureSoul(ItemStack stack, LivingEntity entity) {
        String type = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING);
        return type.isEmpty() || type.equals(RegistryHelper.getRegistryString((Entity)entity));
    }

    public boolean captureSoul(LivingEntity entity) {
        Mob mob;
        boolean hasReceptacle;
        boolean wasOffline;
        if (entity.m_9236_().m_5776_()) {
            return false;
        }
        String entityString = RegistryHelper.getRegistryString((Entity)entity);
        if (entityString.isEmpty()) {
            return false;
        }
        TameableType tameableType = TameableType.getType(entityString);
        if (tameableType == null) {
            return false;
        }
        UUID ownerId = tameableType.getOwnerId((Entity)entity);
        MinecraftServer server = entity.m_20194_();
        if (ownerId == null || server == null) {
            return false;
        }
        @Nullable ServerPlayer owner = server.m_6846_().m_11259_(ownerId);
        boolean bl = wasOffline = owner == null;
        if (wasOffline && (owner = EntityHelper.getOfflinePlayer(server, ownerId)) == null) {
            return false;
        }
        ItemStack receptacle = owner.m_6084_() ? InventoryHelper.findFirstInInventory((Player)owner, stack -> stack.m_150930_((Item)this) && this.canCaptureSoul((ItemStack)stack, entity) && !this.containSoul((ItemStack)stack)) : ItemStack.f_41583_;
        boolean bl2 = hasReceptacle = !receptacle.m_41619_();
        if (hasReceptacle && EventFactory.onCaptureSoul((Player)owner, entity)) {
            hasReceptacle = false;
        }
        if (entity.m_5803_()) {
            entity.m_5796_();
        }
        if (entity.m_20159_()) {
            entity.m_8127_();
        }
        if (entity.m_20160_()) {
            entity.m_20153_();
        }
        if (entity instanceof Mob && (mob = (Mob)entity).m_21523_()) {
            mob.m_21455_(true, false);
        }
        CompoundTag pet_tag = entity.serializeNBT();
        pet_tag.m_128473_("Dimension");
        pet_tag.m_128473_("Motion");
        pet_tag.m_128473_("UUID");
        pet_tag.m_128473_("UpdateBlocked");
        pet_tag.m_128350_("Health", 0.0f);
        pet_tag.m_128350_("max_life", entity.m_21233_());
        if (!hasReceptacle) {
            CommandTBReviveFamiliar.saveFamiliar(server, ownerId, pet_tag, entity.m_20148_().toString());
            return false;
        }
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)entity);
        IntStream.range(0, itemHandler.getSlots()).forEach(slot -> {
            ItemStack currentStack = itemHandler.getStackInSlot(slot);
            if (!currentStack.m_41619_()) {
                itemHandler.extractItem(slot, currentStack.m_41613_(), false);
            }
        });
        tameableType.onCapture((Entity)entity, pet_tag);
        receptacle.m_41784_().m_128365_(DEAD_PET_NBT_COMPOUND, (Tag)pet_tag);
        if (wasOffline) {
            EntityHelper.writePlayerData(server, (Player)owner);
        } else {
            LangKey.MESSAGE_CAPTURE_FAMILIAR.sendSpecialMessage((Player)owner, entity.m_7755_());
            ModTriggers.CAPTURE_SOUL.trigger(owner);
        }
        return true;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_(DEAD_PET_NBT_COMPOUND, 10)) {
            CompoundTag tag = stack.m_41783_().m_6426_();
            CompoundTag pet_tag = tag.m_128469_(DEAD_PET_NBT_COMPOUND);
            if (pet_tag.m_128425_("id", 8)) {
                CompoundTag newTag = new CompoundTag();
                newTag.m_128359_("id", pet_tag.m_128461_("id"));
                if (pet_tag.m_128441_("Health")) {
                    newTag.m_128350_("Health", pet_tag.m_128457_("Health"));
                }
                if (pet_tag.m_128441_("max_life")) {
                    newTag.m_128350_("max_life", pet_tag.m_128457_("max_life"));
                }
                tag.m_128365_(DEAD_PET_NBT_COMPOUND, (Tag)newTag);
            } else {
                pet_tag.m_128473_(DEAD_PET_NBT_COMPOUND);
            }
            return tag;
        }
        return stack.m_41783_();
    }

    public ItemStack setRandomFamiliar(ItemStack stack) {
        if (stack.m_150930_((Item)this)) {
            CompoundTag pet_tag = new CompoundTag();
            String type = TameableType.getRandomTameableEntityTypeString();
            pet_tag.m_128359_("id", type);
            if (TameableType.getType(type) == TameableType.UNDEAD && Helper.RANDOM.nextInt(10) == 0) {
                pet_tag.m_128379_("is_spellcaster", true);
            }
            stack.m_41784_().m_128365_(DEAD_PET_NBT_COMPOUND, (Tag)pet_tag);
        }
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        return this.setRandomFamiliar(stack);
    }
}

