/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.init;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.init.events.EffectSyncEvents;
import dev.xkmc.twilightdelight.events.NeapolitanEventListeners;
import dev.xkmc.twilightdelight.init.data.ExtraLootGen;
import dev.xkmc.twilightdelight.init.data.GLMGen;
import dev.xkmc.twilightdelight.init.data.LangData;
import dev.xkmc.twilightdelight.init.data.ModFilePackResources;
import dev.xkmc.twilightdelight.init.data.RecipeGen;
import dev.xkmc.twilightdelight.init.data.TDDatapackRegistriesGen;
import dev.xkmc.twilightdelight.init.data.TDDatapackTagsGen;
import dev.xkmc.twilightdelight.init.data.TDModConfig;
import dev.xkmc.twilightdelight.init.data.TagGen;
import dev.xkmc.twilightdelight.init.registrate.TDBlocks;
import dev.xkmc.twilightdelight.init.registrate.TDEffects;
import dev.xkmc.twilightdelight.init.registrate.TDItems;
import dev.xkmc.twilightdelight.init.registrate.TDRecipes;
import dev.xkmc.twilightdelight.init.registrate.delight.DelightFood;
import dev.xkmc.twilightdelight.init.registrate.delight.DelightPie;
import dev.xkmc.twilightdelight.init.registrate.neapolitan.NeapolitanCakes;
import dev.xkmc.twilightdelight.init.registrate.neapolitan.NeapolitanFood;
import dev.xkmc.twilightdelight.mixin.FoodPropertiesAccessor;
import dev.xkmc.twilightdelight.mixin.ItemAccessor;
import dev.xkmc.twilightdelight.util.StoveAddBlockUtil;
import java.util.function.Supplier;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.slf4j.Logger;
import twilightforest.init.TFItems;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModEffects;

@Mod(value="twilightdelight")
@Mod.EventBusSubscriber(modid="twilightdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TwilightDelight {
    public static final String MODID = "twilightdelight";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final L2Registrate REGISTRATE = new L2Registrate("twilightdelight");

    public TwilightDelight() {
        TDBlocks.register();
        TDItems.register();
        DelightFood.register();
        DelightPie.register();
        if (ModList.get().isLoaded("neapolitan")) {
            NeapolitanFood.register();
            NeapolitanCakes.register();
            MinecraftForge.EVENT_BUS.register(NeapolitanEventListeners.class);
        }
        TDEffects.register();
        TDRecipes.register(FMLJavaModLoadingContext.get().getModEventBus());
        TDModConfig.init();
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, TagGen::genItemTag);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, TagGen::genBlockTag);
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::genLang);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipes);
        REGISTRATE.addDataGenerator(ProviderType.LOOT, ExtraLootGen::genLoot);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StoveAddBlockUtil.addBlock((BlockEntityType)ModBlockEntityTypes.STOVE.get(), (Block)TDBlocks.MAZE_STOVE.get());
            StoveAddBlockUtil.addBlock((BlockEntityType)ModBlockEntityTypes.COOKING_POT.get(), (Block)TDBlocks.FIERY_POT.get());
            ((FoodPropertiesAccessor)((Item)TFItems.MEEF_STROGANOFF.get()).m_41473_()).getEffectSupplierList().add((Pair<Supplier<MobEffectInstance>, Float>)Pair.of(() -> new MobEffectInstance((MobEffect)ModEffects.NOURISHMENT.get(), 6000), (Object)Float.valueOf(1.0f)));
            ComposterBlock.f_51914_.put((Object)((MushroomColonyBlock)TDBlocks.MUSHGLOOM_COLONY.get()).m_5456_(), 1.0f);
            EffectSyncEvents.TRACKED.add((MobEffect)TDEffects.FIRE_RANGE.get());
            EffectSyncEvents.TRACKED.add((MobEffect)TDEffects.FROZEN_RANGE.get());
            EffectSyncEvents.TRACKED.add((MobEffect)TDEffects.POISON_RANGE.get());
            EffectSyncEvents.TRACKED.add((MobEffect)TDEffects.AURORA_GLOWING.get());
            if (ModList.get().isLoaded("neapolitan")) {
                ((ItemAccessor)NeapolitanItems.ADZUKI_ICE_CREAM.get()).setCraftingRemainingItem(Items.f_42399_);
                ((ItemAccessor)NeapolitanItems.BANANA_ICE_CREAM.get()).setCraftingRemainingItem(Items.f_42399_);
                ((ItemAccessor)NeapolitanItems.MINT_ICE_CREAM.get()).setCraftingRemainingItem(Items.f_42399_);
            }
        });
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new GLMGen(event.getGenerator()));
        PackOutput output = event.getGenerator().getPackOutput();
        TDDatapackRegistriesGen reg = new TDDatapackRegistriesGen(output, event.getLookupProvider());
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)reg);
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new TDDatapackTagsGen(output, reg.getRegistryProvider(), event.getExistingFileHelper()));
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(MODID);
            if (modFileInfo == null) {
                return;
            }
            String builtin = "shader_compatible_fiery";
            IModFile modFile = modFileInfo.getFile();
            event.addRepositorySource(consumer -> {
                Pack pack = Pack.m_245429_((String)("twilightdelight:" + builtin), (Component)Component.m_237113_((String)"Shader Compatible Fiery"), (boolean)false, id -> new ModFilePackResources(id, modFile, "resourcepacks/" + builtin), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                if (pack != null) {
                    consumer.accept(pack);
                }
            });
        }
    }
}

