/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.mixin;

import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.twilightdelight.init.registrate.TDBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;

@Mixin(value={CookingPotBlockEntity.class})
public abstract class CookingPotBlockEntityMixin
extends SyncedBlockEntity
implements HeatableBlockEntity {
    @Shadow(remap=false)
    private int cookTime;
    @Shadow(remap=false)
    @Final
    private ItemStackHandler inventory;
    @Shadow(remap=false)
    private int cookTimeTotal;

    @Shadow(remap=false)
    protected abstract boolean hasInput();

    @Shadow(remap=false)
    public abstract boolean isHeated();

    @Shadow(remap=false)
    protected abstract Optional<CookingPotRecipe> getMatchingRecipe(RecipeWrapper var1);

    @Shadow(remap=false)
    protected abstract boolean canCook(CookingPotRecipe var1);

    @Shadow(remap=false)
    protected abstract boolean processCooking(CookingPotRecipe var1, CookingPotBlockEntity var2);

    @Shadow(remap=false)
    public abstract ItemStack getMeal();

    @Shadow(remap=false)
    protected abstract boolean doesMealHaveContainer(ItemStack var1);

    @Shadow(remap=false)
    protected abstract void moveMealToOutput();

    @Shadow(remap=false)
    protected abstract void useStoredContainersOnMeal();

    public CookingPotBlockEntityMixin(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Inject(at={@At(value="HEAD")}, method={"processCooking"}, remap=false)
    public void twilightdelight$processCooking$fasterCooking(CookingPotRecipe recipe, CookingPotBlockEntity cookingPot, CallbackInfoReturnable<Boolean> cir) {
        Item item;
        ResourceLocation id;
        boolean maze;
        if (this.f_58857_ == null) {
            return;
        }
        BlockState below = this.f_58857_.m_8055_(this.m_58899_().m_7495_());
        boolean fiery = this.m_58900_().m_60713_((Block)TDBlocks.FIERY_POT.get());
        boolean bl = maze = below.m_60734_() == TDBlocks.MAZE_STOVE.get();
        if ((fiery || maze) && (id = ForgeRegistries.ITEMS.getKey((Object)(item = recipe.m_8043_(this.f_58857_.m_9598_()).m_41720_()))) != null && (id.m_135827_().equals("twilightforest") || id.m_135827_().equals("twilightdelight"))) {
            int time = recipe.getCookTime();
            if (fiery) {
                time = Math.min(200, time);
            }
            if (maze) {
                time /= 2;
            }
            int total = Math.max(1, time);
            int factor = recipe.getCookTime() / total;
            this.cookTime += factor - 1;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isHeated"}, remap=false, cancellable=true)
    public void twilightdelight$isHeated$fieryPot(CallbackInfoReturnable<Boolean> cir) {
        if (this.m_58900_().m_60713_((Block)TDBlocks.FIERY_POT.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"cookingTick"}, remap=false, cancellable=true)
    private static void twilightDelight$cookingTick$impl(Level level, BlockPos pos, BlockState state, CookingPotBlockEntity self, CallbackInfo ci) {
        if (state.m_60713_((Block)TDBlocks.FIERY_POT.get())) {
            CookingPotBlockEntityMixin cookingPot = (CookingPotBlockEntityMixin)((Object)Wrappers.cast((Object)self));
            boolean isHeated = cookingPot.isHeated();
            boolean didInventoryChange = false;
            if (isHeated && cookingPot.hasInput()) {
                Optional<CookingPotRecipe> recipe = cookingPot.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)cookingPot.inventory));
                if (recipe.isPresent() && cookingPot.canCook(recipe.get())) {
                    didInventoryChange = cookingPot.processCooking(recipe.get(), self);
                } else {
                    cookingPot.cookTime = 0;
                }
            } else if (cookingPot.cookTime > 0) {
                cookingPot.cookTime = Mth.m_14045_((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
            }
            ItemStack mealStack = cookingPot.getMeal();
            if (!mealStack.m_41619_()) {
                if (!cookingPot.doesMealHaveContainer(mealStack)) {
                    cookingPot.moveMealToOutput();
                    didInventoryChange = true;
                } else if (!cookingPot.inventory.getStackInSlot(7).m_41619_()) {
                    cookingPot.useStoredContainersOnMeal();
                    didInventoryChange = true;
                }
            }
            if (didInventoryChange) {
                cookingPot.inventoryChanged();
            }
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"animationTick"}, remap=false, cancellable=true)
    private static void twilightDelight$animationTick$impl(Level level, BlockPos pos, BlockState state, CookingPotBlockEntity self, CallbackInfo ci) {
        if (state.m_60713_((Block)TDBlocks.FIERY_POT.get())) {
            CookingPotBlockEntityMixin cookingPot = (CookingPotBlockEntityMixin)((Object)Wrappers.cast((Object)self));
            if (cookingPot.isHeated()) {
                double z;
                double y;
                double x;
                RandomSource random = level.f_46441_;
                if (random.m_188501_() < 0.2f) {
                    x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
                    y = (double)pos.m_123342_() + 0.7;
                    z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.0, 0.0);
                }
                if (random.m_188501_() < 0.05f) {
                    x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                    y = (double)pos.m_123342_() + 0.5;
                    z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                    double motionY = random.m_188499_() ? 0.015 : 0.005;
                    level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
                }
            }
            ci.cancel();
        }
    }
}

