/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import twilightforest.entity.boss.SnowQueen;

public class SnowQueenModel
extends HumanoidModel<SnowQueen> {
    public SnowQueenModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partRoot = mesh.m_171576_();
        PartDefinition head = partRoot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        partRoot.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition crown = head.m_171599_("crown", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        SnowQueenModel.makeFrontCrown(crown, -1.0f, -4.0f, 10.0f, 0);
        SnowQueenModel.makeFrontCrown(crown, 0.0f, 4.0f, -10.0f, 1);
        SnowQueenModel.makeSideCrown(crown, -1.0f, -4.0f, 10.0f, 0);
        SnowQueenModel.makeSideCrown(crown, 0.0f, 4.0f, -10.0f, 1);
        partRoot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 23.0f, 4.0f), PartPose.f_171404_);
        partRoot.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171481_(-2.0f, -2.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partRoot.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171481_(-1.0f, -2.0f, -1.3f, 3.0f, 12.0f, 3.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partRoot.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        partRoot.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    private static void makeSideCrown(PartDefinition parent, float spikeDepth, float crownX, float angle, int iteration) {
        PartDefinition crownSide = parent.m_171599_("crown_side_" + iteration, CubeListBuilder.m_171558_().m_171514_(28, 28).m_171481_(-3.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f), PartPose.m_171423_((float)crownX, (float)-6.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        crownSide.m_171599_("spike_4", CubeListBuilder.m_171558_().m_171514_(48, 27).m_171481_(-0.5f, -3.5f, spikeDepth, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)(angle * 1.5f / 180.0f * (float)Math.PI), (float)0.0f, (float)0.0f));
        crownSide.m_171599_("spike_3l", CubeListBuilder.m_171558_().m_171514_(52, 28).m_171481_(-0.5f, -2.5f, spikeDepth, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-2.5f, (float)0.0f, (float)0.0f, (float)(angle / 180.0f * (float)Math.PI), (float)0.0f, (float)-0.17453294f));
        crownSide.m_171599_("spike_3r", CubeListBuilder.m_171558_().m_171514_(52, 28).m_171481_(-0.5f, -2.5f, spikeDepth, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)2.5f, (float)0.0f, (float)0.0f, (float)(angle / 180.0f * (float)Math.PI), (float)0.0f, (float)0.17453294f));
    }

    private static void makeFrontCrown(PartDefinition parent, float spikeDepth, float crownZ, float angle, int iteration) {
        PartDefinition crownFront = parent.m_171599_("crown_front_" + iteration, CubeListBuilder.m_171558_().m_171514_(28, 30).m_171481_(-4.5f, -0.5f, -0.5f, 9.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)crownZ));
        crownFront.m_171599_("spike_4", CubeListBuilder.m_171558_().m_171514_(48, 27).m_171481_(-0.5f, -3.5f, spikeDepth, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)(angle * 1.5f / 180.0f * (float)Math.PI), (float)0.0f, (float)0.0f));
        crownFront.m_171599_("spike_3l", CubeListBuilder.m_171558_().m_171514_(52, 28).m_171481_(-0.5f, -2.5f, spikeDepth, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-2.5f, (float)0.0f, (float)0.0f, (float)(angle / 180.0f * (float)Math.PI), (float)0.0f, (float)-0.17453279f));
        crownFront.m_171599_("spike_3r", CubeListBuilder.m_171558_().m_171514_(52, 28).m_171481_(-0.5f, -2.5f, spikeDepth, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)2.5f, (float)0.0f, (float)0.0f, (float)(angle / 180.0f * (float)Math.PI), (float)0.0f, (float)0.17453279f));
    }

    public void setupAnim(SnowQueen entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.getCurrentPhase() == SnowQueen.Phase.BEAM) {
            if (entity.isBreathing()) {
                float f6 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
                float f7 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
                this.f_102811_.f_104205_ = 0.0f;
                this.f_102812_.f_104205_ = 0.0f;
                this.f_102811_.f_104204_ = -(0.1f - f6 * 0.6f);
                this.f_102812_.f_104204_ = 0.1f - f6 * 0.6f;
                this.f_102811_.f_104203_ = -1.5707964f;
                this.f_102812_.f_104203_ = -1.5707964f;
                this.f_102811_.f_104203_ -= f6 * 1.2f - f7 * 0.4f;
                this.f_102812_.f_104203_ -= f6 * 1.2f - f7 * 0.4f;
                this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
                this.f_102812_.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
                this.f_102811_.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
                this.f_102812_.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            } else {
                this.f_102811_.f_104203_ = (float)((double)this.f_102811_.f_104203_ + Math.PI);
                this.f_102812_.f_104203_ = (float)((double)this.f_102812_.f_104203_ + Math.PI);
            }
        }
    }
}

