/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFSounds;
import twilightforest.util.LegacyLandmarkPlacements;

public class HedgeSpider
extends Spider {
    public HedgeSpider(EntityType<? extends HedgeSpider> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.f_25345_.removeIf(t -> t.m_26015_() instanceof MeleeAttackGoal);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            protected double m_6639_(LivingEntity attackTarget) {
                return 4.0f + attackTarget.m_20205_();
            }
        });
        this.f_21346_.f_25345_.removeIf(t -> t.m_26012_() == 2 && t.m_26015_() instanceof NearestAttackableTargetGoal);
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static boolean isValidLightLevel(ServerLevelAccessor accessor, BlockPos pos, RandomSource random) {
        int chunkZ;
        int chunkX = Mth.m_14143_((float)pos.m_123341_()) >> 4;
        return LegacyLandmarkPlacements.getNearestLandmark(chunkX, chunkZ = Mth.m_14143_((float)pos.m_123343_()) >> 4, (WorldGenLevel)((ServerLevel)accessor)) == TFLandmark.HEDGE_MAZE || Monster.m_219009_((ServerLevelAccessor)accessor, (BlockPos)pos, (RandomSource)random);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.HEDGE_SPIDER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.HEDGE_SPIDER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.HEDGE_SPIDER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)TFSounds.HEDGE_SPIDER_STEP.get(), 0.15f, 1.0f);
    }

    public static boolean canSpawn(EntityType<HedgeSpider> type, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return accessor.m_46791_() != Difficulty.PEACEFUL && HedgeSpider.isValidLightLevel(accessor, pos, random);
    }
}

