/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;
import twilightforest.world.components.structures.util.StructureHints;

public class GenerateBookCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_RUN_BY_PLAYER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.tffeature.not_player"));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"genbook").executes(context -> GenerateBookCommand.generateBook((CommandSourceStack)context.getSource(), null))).requires(cs -> cs.m_6761_(3))).then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceKeyArgument.m_212386_((ResourceKey)Registries.f_256944_)).executes(context -> GenerateBookCommand.generateBook((CommandSourceStack)context.getSource(), (Holder.Reference<Structure>)ResourceKeyArgument.m_247318_((CommandContext)context, (String)"structure"))));
    }

    private static int generateBook(CommandSourceStack source, @Nullable Holder.Reference<Structure> structureKey) throws CommandSyntaxException {
        Player player;
        Entity entity = source.m_81373_();
        if (!(entity instanceof Player) || (player = (Player)entity) instanceof FakePlayer) {
            throw ERROR_NOT_RUN_BY_PLAYER.create();
        }
        if (structureKey == null) {
            for (Structure structure : source.m_81372_().m_9598_().m_175515_(Registries.f_256944_).m_123024_().toList()) {
                StructureHints hint;
                if (!(structure instanceof StructureHints) || player.m_36356_((hint = (StructureHints)structure).createHintBook())) continue;
                player.m_36176_(hint.createHintBook(), true);
            }
        } else {
            Object structure = source.m_81372_().m_9598_().m_175515_(Registries.f_256944_).m_6246_(structureKey.m_205785_());
            if (structure instanceof StructureHints) {
                StructureHints hint = (StructureHints)structure;
                if (!player.m_36356_(hint.createHintBook())) {
                    player.m_36176_(hint.createHintBook(), true);
                }
            } else {
                ItemStack book = StructureHints.HintConfig.defaultBook();
                if (!player.m_36356_(book)) {
                    player.m_36176_(book, true);
                }
            }
        }
        return 1;
    }
}

