/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.structures.HollowHillComponent;

public class YetiCaveComponent
extends HollowHillComponent {
    private static final Stalactite BLUE_ICE_SPIKE = new Stalactite(Map.of(Blocks.f_50568_, 1), 1.0f, 8, 1);
    private static final Stalactite PACKED_ICE_SPIKE = new Stalactite(Map.of(Blocks.f_50354_, 1), 0.5f, 9, 1);
    private static final Stalactite ICE_SPIKE = new Stalactite(Map.of(Blocks.f_50126_, 1), 0.6f, 10, 1);

    public YetiCaveComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFYeti.get(), nbt);
    }

    public YetiCaveComponent(int i, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFYeti.get(), i, 2, x, y, z);
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos.MutableBlockPos dest;
        int i;
        int sn = 64;
        for (i = 0; i < sn; ++i) {
            dest = this.randomCeilingCoordinates(rand, 24.0f);
            this.generateBlockSpike(world, BLUE_ICE_SPIKE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb, true);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.randomCeilingCoordinates(rand, 24.0f);
            this.generateBlockSpike(world, PACKED_ICE_SPIKE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb, true);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.randomCeilingCoordinates(rand, 24.0f);
            this.generateBlockSpike(world, ICE_SPIKE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb, true);
        }
        for (i = 0; i < sn; ++i) {
            dest = this.randomCeilingCoordinates(rand, 24.0f);
            this.generateBlockSpike(world, BlockSpikeFeature.STONE_STALACTITE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb, true);
        }
        BlockState yetiSpawner = ((Block)TFBlocks.ALPHA_YETI_BOSS_SPAWNER.get()).m_49966_();
        this.setBlockStateRotated(world, yetiSpawner, this.radius, 1, this.radius, Rotation.NONE, sbb);
    }

    @Override
    boolean isInHill(int cx, int cz) {
        return cx < this.radius * 2 && cx > 0 && cz < this.radius * 2 && cz > 0;
    }

    @Override
    BlockPos.MutableBlockPos randomCeilingCoordinates(RandomSource rand, float maximumRadius) {
        int rad = (int)maximumRadius;
        int x = rand.m_188503_(rad * 2) - rad;
        int z = rand.m_188503_(rad * 2) - rad;
        int dist = Math.min(Math.abs(x), Math.abs(z));
        return new BlockPos.MutableBlockPos(this.radius + x, 17 - dist / 6, this.radius + z);
    }
}

