/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.phys.Vec3;

public class MathUtil {
    public static final RandomSource RANDOM = RandomSource.m_216327_();

    public static Vec3 rotateVectorAroundYCC(Vec3 vec, double angle) {
        return MathUtil.rotateVectorCC(vec, new Vec3(0.0, 1.0, 0.0), angle);
    }

    public static Vec3 rotateVectorCC(Vec3 vec, Vec3 axis, double angle) {
        double x = vec.m_7096_();
        double y = vec.m_7098_();
        double z = vec.m_7094_();
        double u = axis.m_7096_();
        double v = axis.m_7098_();
        double w = axis.m_7094_();
        double rotationX = u * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + x * Math.cos(angle) + (-w * y + v * z) * Math.sin(angle);
        double rotationY = v * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + y * Math.cos(angle) + (w * x - u * z) * Math.sin(angle);
        double rotationZ = w * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + z * Math.cos(angle) + (-v * x + u * y) * Math.sin(angle);
        return new Vec3(rotationX, rotationY, rotationZ);
    }

    public static int randomNumberInRange(int min, int max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static int randomNumberInRange(RandomSource random, int min, int max) {
        return random.m_188503_(max - min + 1) + min;
    }

    public static float randomNumberInRange(float min, float max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static float randomNumberInRange(RandomSource random, float min, float max) {
        return random.m_188501_() * (max - min) + min;
    }

    public static double randomNumberInRange(double min, double max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static double randomNumberInRange(RandomSource random, double min, double max) {
        return random.m_188500_() * (max - min) + min;
    }

    public static int valueInRange(int min, int max, int value) {
        return Math.min(max, Math.max(min, value));
    }

    public static long valueInRange(long min, long max, long value) {
        return Math.min(max, Math.max(min, value));
    }

    public static float valueInRange(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public static double valueInRange(double min, double max, double value) {
        return Math.min(max, Math.max(min, value));
    }

    public static float getPlaneDistance(int x1, int z1, int x2, int z2) {
        int xDiff = x2 - x1;
        int zDiff = z2 - z1;
        return Mth.m_14116_((float)(xDiff * xDiff + zDiff * zDiff));
    }

    public record RandomSourceWrapper(Random random) implements RandomSource
    {
        public RandomSource m_213769_() {
            return new LegacyRandomSource(this.m_188505_());
        }

        public PositionalRandomFactory m_188582_() {
            return new LegacyRandomSource.LegacyPositionalRandomFactory(this.m_188505_());
        }

        public void m_188584_(long seed) {
            this.random.setSeed(seed);
        }

        public int m_188502_() {
            return this.random.nextInt();
        }

        public int m_188503_(int bound) {
            return this.random.nextInt(bound);
        }

        public long m_188505_() {
            return this.random.nextLong();
        }

        public boolean m_188499_() {
            return this.random.nextBoolean();
        }

        public float m_188501_() {
            return this.random.nextFloat();
        }

        public double m_188500_() {
            return this.random.nextDouble();
        }

        public double m_188583_() {
            return this.random.nextGaussian();
        }
    }
}

