/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.data.builder;

import com.google.gson.JsonObject;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeSerializers;
import info.u_team.useful_railroads.recipe.FuelRecipe;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class FuelRecipeBuilder {
    private final FuelRecipe.Serializer<?> serializer;
    private final Ingredient ingredient;
    private final int fuel;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group;

    public static FuelRecipeBuilder teleportRailFuel(Ingredient ingredient, int fuel) {
        return new FuelRecipeBuilder((FuelRecipe.Serializer)UsefulRailroadsRecipeSerializers.TELEPORT_RAIL_FUEL.get(), ingredient, fuel);
    }

    public static FuelRecipeBuilder trackBuilderFuel(Ingredient ingredient, int fuel) {
        return new FuelRecipeBuilder((FuelRecipe.Serializer)UsefulRailroadsRecipeSerializers.TRACK_BUILDER_FUEL.get(), ingredient, fuel);
    }

    protected FuelRecipeBuilder(FuelRecipe.Serializer<?> serializer, Ingredient ingredient, int fuel) {
        this.serializer = serializer;
        this.ingredient = ingredient;
        this.fuel = fuel;
    }

    public FuelRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, String save) {
        this.save(consumer, new ResourceLocation(save));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(this.serializer, id, this.group == null ? "" : this.group, this.ingredient, this.fuel, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_())));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final FuelRecipe.Serializer<?> serializer;
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final int fuel;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(FuelRecipe.Serializer<?> serializer, ResourceLocation id, String group, Ingredient ingredient, int fuel, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.serializer = serializer;
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.fuel = fuel;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("fuel", (Number)this.fuel);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

