/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.data.provider;

import info.u_team.u_team_core.data.CommonRecipeProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.useful_railroads.data.builder.FuelRecipeBuilder;
import info.u_team.useful_railroads.init.UsefulRailroadsBlocks;
import info.u_team.useful_railroads.init.UsefulRailroadsItems;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class UsefulRailroadsRecipeProvider
extends CommonRecipeProvider {
    public UsefulRailroadsRecipeProvider(GenerationData generationData) {
        super(generationData);
    }

    public void register(Consumer<FinishedRecipe> consumer) {
        this.registerCraftingRecipes(consumer);
        this.registerFuelRecipes(consumer);
    }

    private void registerCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)UsefulRailroadsBlocks.HIGHSPEED_RAIL.get()), (int)24).m_126130_("IDI").m_126130_("LSL").m_126130_("IRI").m_126124_(Character.valueOf('R'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.DUSTS_REDSTONE)).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('I'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.INGOTS_IRON)).m_126124_(Character.valueOf('D'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.GEMS_DIAMOND)).m_126124_(Character.valueOf('L'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.GEMS_LAPIS)).m_126132_("has_minecart", (CriterionTriggerInstance)this.has((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)UsefulRailroadsBlocks.SPEED_CLAMP_RAIL.get()), (int)24).m_126130_("IDI").m_126130_("LSL").m_126130_("IRI").m_126124_(Character.valueOf('R'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.DUSTS_REDSTONE)).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('I'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.INGOTS_IRON)).m_126124_(Character.valueOf('D'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.GEMS_EMERALD)).m_126124_(Character.valueOf('L'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.SLIMEBALLS)).m_126132_("has_minecart", (CriterionTriggerInstance)this.has((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)UsefulRailroadsBlocks.DIRECTION_RAIL.get()), (int)16).m_126130_("IEI").m_126130_("IRI").m_126130_("ISI").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('R'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.DUSTS_REDSTONE)).m_126124_(Character.valueOf('I'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.INGOTS_IRON)).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42350_).m_126132_("has_minecart", (CriterionTriggerInstance)this.has((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)UsefulRailroadsBlocks.TELEPORT_RAIL.get()), (int)1).m_126130_("IDI").m_126130_("ESE").m_126130_("IRI").m_126124_(Character.valueOf('R'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.DUSTS_REDSTONE)).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('I'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.INGOTS_IRON)).m_126124_(Character.valueOf('D'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.GEMS_DIAMOND)).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42584_).m_126132_("has_minecart", (CriterionTriggerInstance)this.has((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)UsefulRailroadsBlocks.INTERSECTION_RAIL.get()), (int)8).m_126130_("III").m_126130_("ISI").m_126130_("III").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('I'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.INGOTS_IRON)).m_126132_("has_minecart", (CriterionTriggerInstance)this.has((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)UsefulRailroadsBlocks.BUFFER_STOP.get()), (int)2).m_126130_("III").m_126130_(" B ").m_126130_("I I").m_126124_(Character.valueOf('B'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.STORAGE_BLOCKS_IRON)).m_126124_(Character.valueOf('I'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.INGOTS_IRON)).m_126132_("has_minecart", (CriterionTriggerInstance)this.has((ItemLike)Items.f_42449_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)UsefulRailroadsItems.SINGLE_TRACK_BUILDER.get()), (int)1).m_126130_("IBI").m_126130_("PRC").m_126130_("IAI").m_126124_(Character.valueOf('I'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.INGOTS_IRON)).m_126124_(Character.valueOf('B'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE)).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42350_).m_126124_(Character.valueOf('R'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.DUSTS_REDSTONE)).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42351_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_41860_).m_126132_("has_redstone", (CriterionTriggerInstance)this.has(Tags.Items.DUSTS_REDSTONE)).m_126132_("has_iron", (CriterionTriggerInstance)this.has(Tags.Items.INGOTS_IRON)).m_126132_("has_rail", (CriterionTriggerInstance)this.has((ItemLike)Items.f_41860_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)UsefulRailroadsItems.DOUBLE_TRACK_BUILDER.get()), (int)1).m_126130_("IBI").m_126130_("PRC").m_126130_("AIA").m_126124_(Character.valueOf('I'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.STORAGE_BLOCKS_IRON)).m_126124_(Character.valueOf('B'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE)).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42350_).m_126124_(Character.valueOf('R'), UsefulRailroadsRecipeProvider.getIngredientOfTag((TagKey)Tags.Items.DUSTS_REDSTONE)).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42351_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_41860_).m_126132_("has_redstone", (CriterionTriggerInstance)this.has(Tags.Items.DUSTS_REDSTONE)).m_126132_("has_iron", (CriterionTriggerInstance)this.has(Tags.Items.INGOTS_IRON)).m_126132_("has_rail", (CriterionTriggerInstance)this.has((ItemLike)Items.f_41860_)).m_176498_(consumer);
        SpecialRecipeBuilder.m_245676_((RecipeSerializer)((RecipeSerializer)UsefulRailroadsRecipeSerializers.CRAFTING_SPECIAL_TELEPORT_RAIL_REMOVE_LOCATION.get())).m_126359_(consumer, "usefulrailroads:teleport_rail_remove_location");
    }

    private void registerFuelRecipes(Consumer<FinishedRecipe> consumer) {
        this.addTeleportRailFuel(Items.f_42584_, 100, consumer, "ender_pearl");
        this.addTeleportRailFuel(Items.f_42545_, 150, consumer, "ender_eye");
        this.addTeleportRailFuel(Items.f_42003_, 250, consumer, "chorus_flower");
        this.addTeleportRailFuel(Items.f_42730_, 200, consumer, "chorus_fruit");
        this.addTeleportRailFuel(Items.f_42731_, 210, consumer, "popped_chorus_fruit");
        this.addTeleportRailFuel((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, 5, consumer, "redstone_dusts");
        this.addTeleportRailFuel((TagKey<Item>)Tags.Items.INGOTS_GOLD, 10, consumer, "gold_ingots");
        this.addTeleportRailFuel((TagKey<Item>)Tags.Items.GEMS_DIAMOND, 50, consumer, "diamond_gems");
        this.addTrackBuilderFuel((TagKey<Item>)ItemTags.f_13160_, 100, consumer, "coals");
        this.addTrackBuilderFuel((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL, 900, consumer, "coal_blocks");
    }

    private void addTeleportRailFuel(Item item, int fuel, Consumer<FinishedRecipe> consumer, String name) {
        this.addTeleportRailFuel(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (CriterionTriggerInstance)this.has((ItemLike)item), fuel, consumer, name);
    }

    private void addTeleportRailFuel(TagKey<Item> tag, int fuel, Consumer<FinishedRecipe> consumer, String name) {
        this.addTeleportRailFuel(UsefulRailroadsRecipeProvider.getIngredientOfTag(tag), (CriterionTriggerInstance)this.has(tag), fuel, consumer, name);
    }

    private void addTeleportRailFuel(Ingredient ingredient, CriterionTriggerInstance trigger, int fuel, Consumer<FinishedRecipe> consumer, String name) {
        FuelRecipeBuilder.teleportRailFuel(ingredient, fuel).addCriterion("has_ingredient", trigger).save(consumer, new ResourceLocation("usefulrailroads", "fuel/teleport_rail/" + name));
    }

    private void addTrackBuilderFuel(TagKey<Item> tag, int fuel, Consumer<FinishedRecipe> consumer, String name) {
        this.addTrackBuilderFuel(UsefulRailroadsRecipeProvider.getIngredientOfTag(tag), (CriterionTriggerInstance)this.has(tag), fuel, consumer, name);
    }

    private void addTrackBuilderFuel(Ingredient ingredient, CriterionTriggerInstance trigger, int fuel, Consumer<FinishedRecipe> consumer, String name) {
        FuelRecipeBuilder.trackBuilderFuel(ingredient, fuel).addCriterion("has_ingredient", trigger).save(consumer, new ResourceLocation("usefulrailroads", "fuel/track_builder/" + name));
    }
}

