/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.inventory;

import info.u_team.useful_railroads.recipe.FuelRecipe;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FuelItemHandler<T extends FuelRecipe>
implements IItemHandlerModifiable {
    private final RecipeType<T> recipeType;
    private final Supplier<Level> levelSupplier;
    private final BooleanSupplier canAddFuel;
    private final IntConsumer fuelAdder;
    private T currentRecipe;
    private ItemStack failedMatch = ItemStack.f_41583_;

    public FuelItemHandler(RecipeType<T> recipeType, Supplier<Level> levelSupplier, IntConsumer fuelAdder) {
        this(recipeType, levelSupplier, () -> true, fuelAdder);
    }

    public FuelItemHandler(RecipeType<T> recipeType, Supplier<Level> levelSupplier, BooleanSupplier canAddFuel, IntConsumer fuelAdder) {
        this.recipeType = recipeType;
        this.levelSupplier = levelSupplier;
        this.canAddFuel = canAddFuel;
        this.fuelAdder = fuelAdder;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.canAddFuel.getAsBoolean() && this.getRecipe(stack, this.levelSupplier.get()).isPresent();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    public int getSlots() {
        return 1;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        Level world = this.levelSupplier.get();
        if (!world.f_46443_) {
            this.getRecipe(stack, world).ifPresent(recipe -> this.fuelAdder.accept(stack.m_41613_() * recipe.getFuel()));
        }
    }

    private Optional<T> getRecipe(ItemStack stack, Level world) {
        SimpleContainer inventory = new SimpleContainer(new ItemStack[]{stack});
        if (stack.m_41619_() || stack == this.failedMatch) {
            return Optional.empty();
        }
        if (this.currentRecipe != null && ((FuelRecipe)this.currentRecipe).m_5818_((Container)inventory, world)) {
            return Optional.of(this.currentRecipe);
        }
        FuelRecipe recipe = world.m_7465_().m_44015_(this.recipeType, (Container)inventory, world).orElse(null);
        this.failedMatch = recipe == null ? stack : ItemStack.f_41583_;
        this.currentRecipe = recipe;
        return Optional.ofNullable(this.currentRecipe);
    }
}

