/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.inventory;

import info.u_team.useful_railroads.init.UsefulRailroadsRecipeTypes;
import info.u_team.useful_railroads.init.UsefulRailroadsTags;
import info.u_team.useful_railroads.inventory.BlockTagItemStackHandler;
import info.u_team.useful_railroads.inventory.FuelItemHandler;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TrackBuilderInventoryWrapper {
    protected final BlockTagItemStackHandler railInventory = new BlockTagItemStackHandler(UsefulRailroadsTags.Items.TRACK_BUILDER_RAILS, 15);
    protected final BlockTagItemStackHandler groundInventory = new BlockTagItemStackHandler(UsefulRailroadsTags.Items.TRACK_BUILDER_GROUND_BLOCKS, 30);
    protected final BlockTagItemStackHandler tunnelInventory = new BlockTagItemStackHandler(UsefulRailroadsTags.Items.TRACK_BUILDER_TUNNEL_BLOCKS, 45);
    protected final BlockTagItemStackHandler redstoneTorchInventory = new BlockTagItemStackHandler(UsefulRailroadsTags.Items.TRACK_BUILDER_REDSTONE_TORCHES, 5);
    protected final BlockTagItemStackHandler torchInventory = new BlockTagItemStackHandler(UsefulRailroadsTags.Items.TRACK_BUILDER_TORCHES, 4);
    protected final IItemHandler fuelInventory;
    protected int fuel = 0;
    protected TrackBuilderMode mode = TrackBuilderMode.MODE_NOAIR;

    private TrackBuilderInventoryWrapper(Supplier<Level> levelSupplier) {
        this.fuelInventory = new FuelItemHandler((RecipeType)UsefulRailroadsRecipeTypes.TRACK_BUILDER_FUEL.get(), levelSupplier, fuelAdder -> this.fuel += fuelAdder);
    }

    public BlockTagItemStackHandler getRailInventory() {
        return this.railInventory;
    }

    public BlockTagItemStackHandler getGroundInventory() {
        return this.groundInventory;
    }

    public BlockTagItemStackHandler getTunnelInventory() {
        return this.tunnelInventory;
    }

    public BlockTagItemStackHandler getRedstoneTorchInventory() {
        return this.redstoneTorchInventory;
    }

    public BlockTagItemStackHandler getTorchInventory() {
        return this.torchInventory;
    }

    public IItemHandler getFuelInventory() {
        return this.fuelInventory;
    }

    public void readItemStack() {
    }

    public void writeItemStack() {
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public TrackBuilderMode getMode() {
        return this.mode;
    }

    public void setMode(TrackBuilderMode mode) {
        this.mode = mode;
    }

    public static class Server
    extends TrackBuilderInventoryWrapper {
        private final ItemStack stack;

        public Server(ItemStack stack, Supplier<Level> levelSupplier) {
            super(levelSupplier);
            this.stack = stack;
            this.readItemStack();
        }

        @Override
        public void readItemStack() {
            this.readItemHandler(this.railInventory, "rail");
            this.readItemHandler(this.groundInventory, "ground");
            this.readItemHandler(this.tunnelInventory, "tunnel");
            this.readItemHandler(this.redstoneTorchInventory, "redstone_torch");
            this.readItemHandler(this.torchInventory, "torch");
            CompoundTag compound = this.stack.m_41783_();
            if (compound != null) {
                this.fuel = compound.m_128451_("fuel");
                this.mode = TrackBuilderMode.byName(compound.m_128461_("mode"));
            }
        }

        @Override
        public void writeItemStack() {
            CompoundTag compound;
            this.writeItemHandler(this.railInventory, "rail");
            this.writeItemHandler(this.groundInventory, "ground");
            this.writeItemHandler(this.tunnelInventory, "tunnel");
            this.writeItemHandler(this.redstoneTorchInventory, "redstone_torch");
            this.writeItemHandler(this.torchInventory, "torch");
            if (this.fuel > 0) {
                compound = this.stack.m_41784_();
                compound.m_128405_("fuel", this.fuel);
            } else {
                compound = this.stack.m_41783_();
                if (compound != null) {
                    compound.m_128473_("fuel");
                }
            }
            if (this.mode != TrackBuilderMode.MODE_NOAIR) {
                compound = this.stack.m_41784_();
                compound.m_128359_("mode", this.mode.getName());
            } else {
                compound = this.stack.m_41783_();
                if (compound != null) {
                    compound.m_128473_("mode");
                }
            }
        }

        private void readItemHandler(ItemStackHandler handler, String childCompoundName) {
            CompoundTag childCompound = this.stack.m_41737_(childCompoundName);
            if (childCompound != null) {
                handler.deserializeNBT(childCompound);
            }
        }

        private void writeItemHandler(ItemStackHandler handler, String childCompoundName) {
            if (IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)handler).getStackInSlot(arg_0)).allMatch(ItemStack::m_41619_)) {
                this.stack.m_41749_(childCompoundName);
            } else {
                this.stack.m_41784_().m_128365_(childCompoundName, (Tag)handler.serializeNBT());
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }

    public static class Client
    extends TrackBuilderInventoryWrapper {
        public Client(int fuel, TrackBuilderMode mode, Supplier<Level> levelSupplier) {
            super(levelSupplier);
            this.fuel = fuel;
            this.mode = mode;
        }
    }
}

