/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.menu;

import info.u_team.u_team_core.api.menu.ItemSlotCreator;
import info.u_team.u_team_core.api.sync.DataHolder;
import info.u_team.u_team_core.api.sync.MessageHolder;
import info.u_team.u_team_core.menu.ItemHandlerSlotCreator;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_railroads.init.UsefulRailroadsMenuTypes;
import info.u_team.useful_railroads.inventory.FuelItemSlotHandler;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.item.TrackBuilderItem;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TrackBuilderMenu
extends UContainerMenu {
    private final TrackBuilderInventoryWrapper wrapper;
    private final MessageHolder.EmptyMessageHolder changeModeMessage;
    private final int selectedSlot;

    public TrackBuilderMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(containerId, playerInventory, new TrackBuilderInventoryWrapper.Client(buffer.m_130242_(), (TrackBuilderMode)buffer.m_130066_(TrackBuilderMode.class), () -> ((Player)playerInventory.f_35978_).m_9236_()), buffer.m_130242_());
    }

    public TrackBuilderMenu(int containerId, Inventory playerInventory, TrackBuilderInventoryWrapper wrapper, int selectedSlot) {
        super((MenuType)UsefulRailroadsMenuTypes.TRACK_BUILDER.get(), containerId);
        this.wrapper = wrapper;
        this.selectedSlot = selectedSlot;
        this.addSlots((index, xPosition, yPosition) -> new FuelItemSlotHandler(wrapper.getFuelInventory(), index, xPosition, yPosition), 1, 1, 260, 182);
        this.addSlots((ItemSlotCreator)ItemHandlerSlotCreator.of((IItemHandler)wrapper.getRailInventory()), 1, 15, 8, 32);
        this.addSlots((ItemSlotCreator)ItemHandlerSlotCreator.of((IItemHandler)wrapper.getGroundInventory()), 2, 15, 8, 64);
        this.addSlots((ItemSlotCreator)ItemHandlerSlotCreator.of((IItemHandler)wrapper.getTunnelInventory()), 3, 15, 8, 114);
        this.addSlots((ItemSlotCreator)ItemHandlerSlotCreator.of((IItemHandler)wrapper.getRedstoneTorchInventory()), 1, 5, 8, 182);
        this.addSlots((ItemSlotCreator)ItemHandlerSlotCreator.of((IItemHandler)wrapper.getTorchInventory()), 1, 4, 116, 182);
        this.addPlayerInventory(playerInventory, 62, 214);
        this.addDataHolderToClient(DataHolder.createIntHolder(wrapper::getFuel, wrapper::setFuel));
        this.addDataHolderToClient(DataHolder.createByteHolder(() -> (byte)wrapper.getMode().ordinal(), value -> wrapper.setMode(((TrackBuilderMode[])TrackBuilderMode.class.getEnumConstants())[value])));
        this.changeModeMessage = (MessageHolder.EmptyMessageHolder)this.addDataHolderToServer((DataHolder)new MessageHolder.EmptyMessageHolder(() -> {
            wrapper.setMode(TrackBuilderMode.cycle(wrapper.getMode()));
            wrapper.writeItemStack();
        }));
    }

    public void m_38946_() {
        super.m_38946_();
        this.wrapper.writeItemStack();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack remainingStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            remainingStack = stack.m_41777_();
            if (index < 97 ? !this.m_38903_(stack, 97, this.f_38839_.size(), true) : (index >= 124 ? !this.m_38903_(stack, 0, 124, false) : !this.m_38903_(stack, 0, 97, false) && !this.m_38903_(stack, 124, 133, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return remainingStack;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        Slot tmpSlot = slotId >= 0 && slotId < this.f_38839_.size() ? (Slot)this.f_38839_.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.f_40218_ == player.m_150109_() && tmpSlot.getSlotIndex() == this.selectedSlot) {
            return;
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.m_150109_().m_8020_(dragType);
            ItemStack itemStack = Inventory.m_36045_((int)this.selectedSlot) ? (ItemStack)player.m_150109_().f_35974_.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.m_150109_().f_35976_.get(0) : ItemStack.f_41583_);
            if (!currentItem.m_41619_() && stack == currentItem) {
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public boolean m_6875_(Player player) {
        if (this.wrapper instanceof TrackBuilderInventoryWrapper.Server) {
            ItemStack stack = ((TrackBuilderInventoryWrapper.Server)this.wrapper).getStack();
            return !stack.m_41619_() && stack.m_41720_() instanceof TrackBuilderItem;
        }
        return true;
    }

    public TrackBuilderInventoryWrapper getWrapper() {
        return this.wrapper;
    }

    public MessageHolder.EmptyMessageHolder getChangeModeMessage() {
        return this.changeModeMessage;
    }
}

