/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerUtil {
    public static int getItemCount(IItemHandler handler, Predicate<? super ItemStack> predicate) {
        return ItemHandlerUtil.getStackStream(handler).filter(predicate).mapToInt(ItemStack::m_41613_).sum();
    }

    public static Stream<ItemStack> getStackStream(IItemHandler handler) {
        return IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0));
    }

    public static List<ItemStack> extractItems(IItemHandler handler, Predicate<? super ItemStack> predicate, int extractCount) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        AtomicInteger countLeft = new AtomicInteger(extractCount);
        IntStream.range(0, handler.getSlots()).filter(slot -> predicate.test(handler.getStackInSlot(slot))).forEach(slot -> {
            int count = countLeft.get();
            if (count > 0) {
                ItemStack stack = handler.extractItem(slot, count, false);
                countLeft.set(count - stack.m_41613_());
                list.add(stack);
            }
        });
        return list;
    }

    public static ItemStack getOneItemAndRemove(List<ItemStack> list) {
        if (list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = list.get(0);
        ItemStack oneItemStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            list.remove(0);
        }
        return oneItemStack;
    }
}

