/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.valhelsia.valhelsia_core.api.common.helper.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public record PlatformDependentValue(Ingredient.Value forgeValue, Ingredient.Value fabricValue) implements Ingredient.Value
{
    public PlatformDependentValue(TagKey<Item> forgeTag, TagKey<Item> fabricTag) {
        this((Ingredient.Value)new Ingredient.TagValue(forgeTag), (Ingredient.Value)new Ingredient.TagValue(fabricTag));
    }

    public PlatformDependentValue(ItemLike forgeItem, ItemLike fabricItem) {
        this((Ingredient.Value)PlatformDependentValue.createItemValue(forgeItem), (Ingredient.Value)PlatformDependentValue.createItemValue(fabricItem));
    }

    public PlatformDependentValue(ResourceLocation forgeTag, ResourceLocation fabricTag) {
        this((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)forgeTag), (TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)fabricTag));
    }

    public static Ingredient createIngredient(ResourceLocation forgeTag, ResourceLocation fabricTag) {
        return Ingredient.m_43938_(Stream.of(new PlatformDependentValue(forgeTag, fabricTag)));
    }

    public static Ingredient createIngredient(ItemLike forgeItem, ItemLike fabricItem) {
        return Ingredient.m_43938_(Stream.of(new PlatformDependentValue((Ingredient.Value)PlatformDependentValue.createItemValue(forgeItem), (Ingredient.Value)PlatformDependentValue.createItemValue(fabricItem))));
    }

    public static Ingredient createIngredient(ResourceLocation forgeTag, ItemLike fabricItem) {
        return Ingredient.m_43938_(Stream.of(new PlatformDependentValue((Ingredient.Value)PlatformDependentValue.createTagValue(forgeTag), (Ingredient.Value)PlatformDependentValue.createItemValue(fabricItem))));
    }

    public static Ingredient createIngredient(ItemLike forgeItem, ResourceLocation fabricTag) {
        return Ingredient.m_43938_(Stream.of(new PlatformDependentValue((Ingredient.Value)PlatformDependentValue.createItemValue(forgeItem), (Ingredient.Value)PlatformDependentValue.createTagValue(fabricTag))));
    }

    private static Ingredient.ItemValue createItemValue(ItemLike item) {
        return new Ingredient.ItemValue(new ItemStack(item));
    }

    private static Ingredient.TagValue createTagValue(ResourceLocation tag) {
        return new Ingredient.TagValue(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag));
    }

    @NotNull
    public Collection<ItemStack> m_6223_() {
        return PlatformHelper.isForge() ? this.forgeValue.m_6223_() : this.fabricValue.m_6223_();
    }

    @NotNull
    public JsonObject m_6544_() {
        JsonObject object = new JsonObject();
        object.add("forge_value", (JsonElement)this.forgeValue.m_6544_());
        object.add("fabric_value", (JsonElement)this.fabricValue.m_6544_());
        return object;
    }
}

