/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.registry.helper.block;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryEntry;
import net.valhelsia.valhelsia_core.api.common.registry.helper.MappedRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockEntrySet;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;

public class BlockRegistryHelper
extends MappedRegistryHelper<Block> {
    public BlockRegistryHelper(ResourceKey<? extends Registry<Block>> registry, String modId, ImmutableList<Class<?>> registryClasses) {
        super(registry, modId, registryClasses);
    }

    @Override
    protected <O extends Block> RegistryEntry<O> createEntry(String name, Supplier<O> supplier) {
        return new BlockRegistryEntry<O>(name, supplier);
    }

    @Override
    public <O extends Block> BlockRegistryEntry<O> register(String name, Supplier<O> object) {
        return (BlockRegistryEntry)super.registerInternal(name, object);
    }

    public <T extends Block> BlockEntrySet<T, DyeColor> registerColorEntrySet(String name, Function<DyeColor, T> function) {
        return this.registerEntrySet(DyeColor.class, name, function);
    }

    public <T extends Block> BlockEntrySet<T, DyeColor> registerColorEntrySet(UnaryOperator<String> name, Function<DyeColor, T> function) {
        return this.registerEntrySet(DyeColor.class, name, function);
    }

    public <T extends Block> BlockEntrySet<T, DyeColor> registerColorEntrySet(String name, Function<DyeColor, T> function, UnaryOperator<BlockRegistryEntry<T>> unaryOperator) {
        return this.registerEntrySet(DyeColor.class, name, function, unaryOperator);
    }

    public <T extends Block> BlockEntrySet<T, DyeColor> registerColorEntrySet(UnaryOperator<String> name, Function<DyeColor, T> function, UnaryOperator<BlockRegistryEntry<T>> unaryOperator) {
        return this.registerEntrySet(DyeColor.class, name, function, unaryOperator);
    }

    public <K extends Enum<K>, T extends Block> BlockEntrySet<T, K> registerEntrySet(Class<K> keyType, String name, Function<K, T> function) {
        return this.registerEntrySet(keyType, s -> s + "_" + name, function);
    }

    public <K extends Enum<K>, T extends Block> BlockEntrySet<T, K> registerEntrySet(Class<K> keyType, UnaryOperator<String> name, Function<K, T> function) {
        BlockEntrySet set = new BlockEntrySet(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            set.put(key, this.register((String)name.apply(((StringRepresentable)key).m_7912_()), () -> (Block)function.apply(key)));
        }
        return set;
    }

    public <K extends Enum<K>, T extends Block> BlockEntrySet<T, K> registerEntrySet(Class<K> keyType, String name, Function<K, T> function, UnaryOperator<BlockRegistryEntry<T>> unaryOperator) {
        return this.registerEntrySet(keyType, s -> s + "_" + name, function, unaryOperator);
    }

    public <K extends Enum<K>, T extends Block> BlockEntrySet<T, K> registerEntrySet(Class<K> keyType, UnaryOperator<String> name, Function<K, T> function, UnaryOperator<BlockRegistryEntry<T>> unaryOperator) {
        BlockEntrySet set = new BlockEntrySet(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            set.put(key, (BlockRegistryEntry)unaryOperator.apply((BlockRegistryEntry<RegistryEntry>)this.register((String)name.apply(((StringRepresentable)key).m_7912_()), () -> (Block)function.apply(key))));
        }
        return set;
    }
}

