/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.compat.ModCompatibility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ChargerBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    private static final int SEARCH_BLOCKS_PER_TICK = 5;
    private static final Set<Direction> CAPABILITY_DIRECTIONS;
    private final LazyOptional<IEnergyStorage> capability = LazyOptional.of(() -> this);
    public final ChargerType f_58855_;
    private int energy;
    private boolean highlightArea;
    private RedstoneMode redstoneMode = RedstoneMode.DISABLED;
    private boolean isRedstonePowered;
    private int blockSearchX;
    private int blockSearchY;
    private int blockSearchZ;
    private final Map<BlockPos, Direction> chargeableBlocks = new LinkedHashMap<BlockPos, Direction>();
    public int renderingTickCount = 0;
    public float renderingRotationSpeed;
    public float renderingRotation;

    public ChargerBlockEntity(ChargerType type, BlockPos pos, BlockState state) {
        super(type.getBlockEntityType(), pos, state);
        this.f_58855_ = type;
    }

    public void update() {
        if (this.f_58857_.f_46443_) {
            ++this.renderingTickCount;
            if (!this.redstoneMode.canOperate(this.isRedstonePowered)) {
                this.renderingRotationSpeed = Math.max(0.0f, this.renderingRotationSpeed - 0.02f);
                this.renderingRotation += this.renderingRotationSpeed;
                return;
            }
            this.renderingRotationSpeed = Math.min(this.renderingRotationSpeed + 0.02f, this.getEnergyFillPercentage());
            this.renderingRotation += this.renderingRotationSpeed;
        } else {
            boolean spawnParticles = false;
            if (this.f_58855_.canChargeBlocks) {
                for (int i = 0; i < 5; ++i) {
                    BlockPos offset = new BlockPos(this.blockSearchX, this.blockSearchY, this.blockSearchZ);
                    BlockPos blockPos = this.f_58858_.m_121955_((Vec3i)offset);
                    if (!blockPos.equals((Object)this.f_58858_)) {
                        BlockEntity entity = this.f_58857_.m_7702_(blockPos);
                        boolean canAcceptEnergy = false;
                        for (Direction direction : CAPABILITY_DIRECTIONS) {
                            if (entity == null || entity instanceof ChargerBlockEntity || !entity.getCapability(ForgeCapabilities.ENERGY, direction).map(IEnergyStorage::canReceive).orElse(false).booleanValue()) continue;
                            this.chargeableBlocks.put(offset, direction);
                            canAcceptEnergy = true;
                            break;
                        }
                        if (!canAcceptEnergy) {
                            this.chargeableBlocks.remove(offset);
                        }
                    }
                    int range = this.f_58855_.range.get();
                    ++this.blockSearchX;
                    if (this.blockSearchX <= range) continue;
                    this.blockSearchX = -range;
                    ++this.blockSearchZ;
                    if (this.blockSearchZ <= range) continue;
                    this.blockSearchZ = -range;
                    ++this.blockSearchY;
                    if (this.blockSearchY <= range) continue;
                    this.blockSearchY = -range;
                }
                if (this.energy > 0) {
                    HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
                    for (Map.Entry<Object, Object> entry : this.chargeableBlocks.entrySet()) {
                        LazyOptional optional;
                        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)entry.getKey()));
                        if (tile != null && (optional = tile.getCapability(ForgeCapabilities.ENERGY, (Direction)entry.getValue())).isPresent()) {
                            int toTransfer = Math.min(this.energy, this.f_58855_.transferRate.get());
                            int transferred = optional.map(storage -> storage.receiveEnergy(toTransfer, false)).orElse(0);
                            if (transferred <= 0) continue;
                            spawnParticles = true;
                            this.energy -= transferred;
                            this.dataChanged();
                            if (this.energy > 0) continue;
                            break;
                        }
                        toRemove.add((BlockPos)entry.getKey());
                    }
                    toRemove.forEach(this.chargeableBlocks::remove);
                }
            }
            if (this.f_58855_.canChargePlayers && this.energy > 0) {
                List players = this.f_58857_.m_45976_(Player.class, this.getOperatingArea());
                block3: for (Player player : players) {
                    int toTransfer = Math.min(this.energy, this.f_58855_.transferRate.get());
                    IItemHandlerModifiable handler = ModCompatibility.curios.getCuriosStacks(player);
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        int max;
                        LazyOptional optional;
                        int transferred;
                        ItemStack stack = handler.getStackInSlot(i);
                        if (stack.m_41619_() || (transferred = (optional = stack.getCapability(ForgeCapabilities.ENERGY)).map(arg_0 -> ChargerBlockEntity.lambda$update$2(max = toTransfer, arg_0)).orElse(0).intValue()) <= 0) continue;
                        handler.setStackInSlot(i, stack);
                        spawnParticles = true;
                        this.energy -= transferred;
                        this.dataChanged();
                        if (this.energy <= 0) break block3;
                        if ((toTransfer -= transferred) <= 0) continue block3;
                    }
                    Inventory inventory = player.m_150109_();
                    for (int i = 0; i < inventory.m_6643_(); ++i) {
                        int max;
                        LazyOptional optional;
                        int transferred;
                        ItemStack stack = inventory.m_8020_(i);
                        if (stack.m_41619_() || (transferred = (optional = stack.getCapability(ForgeCapabilities.ENERGY)).map(arg_0 -> ChargerBlockEntity.lambda$update$3(max = toTransfer, arg_0)).orElse(0).intValue()) <= 0) continue;
                        inventory.m_6836_(i, stack);
                        spawnParticles = true;
                        this.energy -= transferred;
                        this.dataChanged();
                        if (this.energy <= 0) break block3;
                        if ((toTransfer -= transferred) <= 0) continue block3;
                    }
                }
            }
            if (spawnParticles && this.f_58857_ instanceof ServerLevel && this.f_58857_.m_213780_().m_188500_() <= (double)this.getEnergyFillPercentage()) {
                double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)this.f_58857_.m_213780_().m_188501_() * 0.8 - 0.4;
                double d = (double)this.f_58858_.m_123342_() + 0.7 + (double)this.f_58857_.m_213780_().m_188501_() * 0.8 - 0.4;
                double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)this.f_58857_.m_213780_().m_188501_() * 0.8 - 0.4;
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, x, d, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public float getEnergyFillPercentage() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.energy / (float)this.f_58855_.capacity.get().intValue()));
    }

    public AABB getOperatingArea() {
        return new AABB(this.f_58858_).m_82400_((double)this.f_58855_.range.get().intValue());
    }

    public void setRedstonePowered(boolean powered) {
        if (this.isRedstonePowered != powered) {
            this.isRedstonePowered = powered;
            this.dataChanged();
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex((this.redstoneMode.index + 1) % RedstoneMode.values().length);
        this.dataChanged();
    }

    public boolean isAreaHighlighted() {
        return this.highlightArea;
    }

    public void toggleHighlightArea() {
        this.highlightArea = !this.highlightArea;
        this.dataChanged();
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("energy", this.energy);
        compound.m_128379_("highlightArea", this.highlightArea);
        compound.m_128405_("redstoneMode", this.redstoneMode.index);
        compound.m_128379_("isRedstonePowered", this.isRedstonePowered);
        if (this.f_58855_.canChargeBlocks) {
            compound.m_128405_("blockSearchX", this.blockSearchX);
            compound.m_128405_("blockSearchY", this.blockSearchX);
            compound.m_128405_("blockSearchZ", this.blockSearchX);
            int[] arr = new int[this.chargeableBlocks.size() * 4];
            int index = 0;
            for (Map.Entry<BlockPos, Direction> entry : this.chargeableBlocks.entrySet()) {
                arr[index] = entry.getKey().m_123341_();
                arr[index + 1] = entry.getKey().m_123342_();
                arr[index + 2] = entry.getKey().m_123343_();
                arr[index + 3] = entry.getValue() == null ? -1 : entry.getValue().m_122411_();
                ++index;
            }
            compound.m_128385_("chargeableBlocks", arr);
        }
        return compound;
    }

    public CompoundTag writeItemStackData() {
        CompoundTag compound = this.writeData();
        if (compound.m_128451_("energy") <= 0 && compound.m_128451_("redstoneMode") == 2) {
            return null;
        }
        compound.m_128473_("highlightArea");
        compound.m_128473_("isRedstonePowered");
        if (this.f_58855_.canChargeBlocks) {
            compound.m_128473_("blockSearchX");
            compound.m_128473_("blockSearchY");
            compound.m_128473_("blockSearchZ");
            compound.m_128473_("chargeableBlocks");
        }
        return compound;
    }

    protected void readData(CompoundTag compound) {
        this.energy = compound.m_128451_("energy");
        this.highlightArea = compound.m_128471_("highlightArea");
        this.redstoneMode = RedstoneMode.fromIndex(compound.m_128451_("redstoneMode"));
        this.isRedstonePowered = compound.m_128471_("isRedstonePowered");
        if (this.f_58855_.canChargeBlocks && compound.m_128441_("chargeableBlocks")) {
            this.blockSearchX = compound.m_128451_("blockSearchX");
            this.blockSearchY = compound.m_128451_("blockSearchY");
            this.blockSearchZ = compound.m_128451_("blockSearchZ");
            int[] arr = compound.m_128465_("chargeableBlocks");
            this.chargeableBlocks.clear();
            for (int i = 0; i < arr.length / 4; ++i) {
                this.chargeableBlocks.put(new BlockPos(arr[i], arr[i + 1], arr[i + 2]), arr[i + 3] == -1 ? null : Direction.m_122376_((int)arr[i + 3]));
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side != Direction.UP) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = Math.min(maxReceive, Math.min(this.f_58855_.capacity.get() - this.energy, this.f_58855_.transferRate.get() * 100));
        if (!simulate) {
            this.energy += received;
            this.dataChanged();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.f_58855_.capacity.get();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public void onChunkUnloaded() {
        this.capability.invalidate();
        super.onChunkUnloaded();
    }

    public AABB getRenderBoundingBox() {
        return this.highlightArea ? this.getOperatingArea() : new AABB(this.f_58858_);
    }

    private static /* synthetic */ Integer lambda$update$3(int max, IEnergyStorage storage) {
        return storage.receiveEnergy(max, false);
    }

    private static /* synthetic */ Integer lambda$update$2(int max, IEnergyStorage storage) {
        return storage.receiveEnergy(max, false);
    }

    static {
        HashSet<Direction> directions = new HashSet<Direction>();
        directions.add(null);
        directions.addAll(Arrays.asList(Direction.values()));
        CAPABILITY_DIRECTIONS = Collections.unmodifiableSet(directions);
    }

    public static enum RedstoneMode {
        HIGH(0),
        LOW(1),
        DISABLED(2);

        public final int index;

        private RedstoneMode(int index) {
            this.index = index;
        }

        public boolean canOperate(boolean isPowered) {
            return this == DISABLED || (isPowered ? this == HIGH : this == LOW);
        }

        public static RedstoneMode fromIndex(int index) {
            for (RedstoneMode mode : RedstoneMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return DISABLED;
        }
    }
}

