/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.api.config.Setting;
import appeng.api.config.YesNo;
import appeng.client.gui.AEBaseScreen;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.LocalizationEnum;
import appeng.util.EnumCycler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIconButton;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import org.jetbrains.annotations.Nullable;

public class AAESettingToggleButton<T extends Enum<T>>
extends AAEIconButton {
    private static Map<EnumPair<?>, ButtonAppearance> appearances;
    private final Setting<T> buttonSetting;
    private final IHandler<AAESettingToggleButton<T>> onPress;
    private final EnumSet<T> validValues;
    private T currentValue;

    public AAESettingToggleButton(Setting<T> setting, T val, IHandler<AAESettingToggleButton<T>> onPress) {
        this((Setting<Enum>)setting, (Enum)val, t -> true, (IHandler<AAESettingToggleButton<Enum>>)onPress);
    }

    public AAESettingToggleButton(Setting<T> setting, T val, Predicate<T> isValidValue, IHandler<AAESettingToggleButton<T>> onPress) {
        super(AAESettingToggleButton::onPress);
        this.onPress = onPress;
        EnumSet<Object> validValues = EnumSet.allOf(((Enum)val).getDeclaringClass());
        validValues.removeIf(isValidValue.negate());
        validValues.removeIf(s -> !setting.getValues().contains(s));
        this.validValues = validValues;
        this.buttonSetting = setting;
        this.currentValue = val;
        if (appearances == null) {
            appearances = new HashMap();
            AAESettingToggleButton.registerApp(AAEIcon.ME_EXPORT_ON, AAESettings.ME_EXPORT, YesNo.YES, (LocalizationEnum)AAEText.MeExport, AAEText.MeExportOn);
            AAESettingToggleButton.registerApp(AAEIcon.ME_EXPORT_OFF, AAESettings.ME_EXPORT, YesNo.NO, (LocalizationEnum)AAEText.MeExport, AAEText.MeExportOff);
        }
    }

    private static void onPress(Button btn) {
        if (btn instanceof AAESettingToggleButton) {
            ((AAESettingToggleButton)btn).triggerPress();
        }
    }

    private void triggerPress() {
        boolean backwards = false;
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof AEBaseScreen) {
            backwards = ((AEBaseScreen)currentScreen).isHandlingRightClick();
        }
        this.onPress.handle(this, backwards);
    }

    private static <T extends Enum<T>> void registerApp(AAEIcon icon, Setting<T> setting, T val, LocalizationEnum title, Component ... tooltipLines) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)title.text());
        Collections.addAll(lines, tooltipLines);
        appearances.put(new EnumPair<T>(setting, val), new ButtonAppearance(icon, null, lines));
    }

    private static <T extends Enum<T>> void registerApp(ItemLike item, Setting<T> setting, T val, LocalizationEnum title, Component ... tooltipLines) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)title.text());
        Collections.addAll(lines, tooltipLines);
        appearances.put(new EnumPair<T>(setting, val), new ButtonAppearance(null, item.m_5456_(), lines));
    }

    private static <T extends Enum<T>> void registerApp(AAEIcon icon, Setting<T> setting, T val, LocalizationEnum title, LocalizationEnum hint) {
        AAESettingToggleButton.registerApp(icon, setting, val, title, new Component[]{hint.text()});
    }

    @Nullable
    private ButtonAppearance getAppearance() {
        if (this.buttonSetting != null && this.currentValue != null) {
            return appearances.get(new EnumPair<T>(this.buttonSetting, this.currentValue));
        }
        return null;
    }

    @Override
    protected AAEIcon getIcon() {
        ButtonAppearance app = this.getAppearance();
        if (app != null && app.icon != null) {
            return app.icon;
        }
        return AAEIcon.TOOLBAR_BUTTON_BACKGROUND;
    }

    @Override
    protected Item getItemOverlay() {
        ButtonAppearance app = this.getAppearance();
        if (app != null && app.item != null) {
            return app.item;
        }
        return null;
    }

    public Setting<T> getSetting() {
        return this.buttonSetting;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public void set(T e) {
        if (this.currentValue != e) {
            this.currentValue = e;
        }
    }

    public T getNextValue(boolean backwards) {
        return (T)EnumCycler.rotateEnum(this.currentValue, (boolean)backwards, this.validValues);
    }

    @Override
    public List<Component> getTooltipMessage() {
        if (this.buttonSetting == null || this.currentValue == null) {
            return Collections.emptyList();
        }
        ButtonAppearance buttonAppearance = appearances.get(new EnumPair<T>(this.buttonSetting, this.currentValue));
        if (buttonAppearance == null) {
            return Collections.singletonList(ButtonToolTips.NoSuchMessage.text());
        }
        return buttonAppearance.tooltipLines;
    }

    @FunctionalInterface
    public static interface IHandler<T extends AAESettingToggleButton<?>> {
        public void handle(T var1, boolean var2);
    }

    private static final class EnumPair<T extends Enum<T>> {
        final Setting<T> setting;
        final T value;

        public EnumPair(Setting<T> setting, T value) {
            this.setting = setting;
            this.value = value;
        }

        public int hashCode() {
            return this.setting.hashCode() ^ ((Enum)this.value).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPair other = (EnumPair)obj;
            return other.setting == this.setting && other.value == this.value;
        }
    }

    private record ButtonAppearance(@Nullable AAEIcon icon, @Nullable Item item, List<Component> tooltipLines) {
    }
}

