/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.NotNull;

public class AAESlider
extends ForgeSlider {
    private static final ResourceLocation BUTTON = AppEng.makeId((String)"button");
    private static final ResourceLocation BUTTON_DISABLED = AppEng.makeId((String)"button_disabled");
    private static final ResourceLocation BUTTON_HIGHLIGHTED = AppEng.makeId((String)"button_highlighted");
    private final Consumer<Double> setter;

    public AAESlider(double minValue, double maxValue, double currentValue, float multiplier) {
        this(minValue, maxValue, currentValue, multiplier, value -> {});
    }

    public AAESlider(double minValue, double maxValue, double currentValue, float multiplier, Consumer<Double> setter) {
        super(0, 0, 100, 20, (Component)Component.m_237119_(), (Component)Component.m_237119_(), minValue, maxValue, currentValue, (double)multiplier, 0, true);
        this.setter = setter;
    }

    public void setValues(double minValue, double maxValue, double currentValue, float multiplier) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = multiplier;
        this.m_93611_(currentValue);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.m_91087_().f_91062_;
        int minX = this.m_252754_() + 4;
        int maxX = this.m_252754_() + this.m_5711_() - 4;
        int middleX = this.m_252754_() + this.m_5711_() / 2;
        int middleY = this.m_252907_() + this.m_93694_() / 2;
        int minY = this.m_252907_() + this.m_93694_() / 4;
        int maxY = this.m_252907_() + 3 * this.m_93694_() / 4;
        int backColor = 0xADB0C4 | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24;
        int lineColor = 0x413F54 | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24;
        guiGraphics.m_280509_(minX - 6, minY - 2, maxX + 6, maxY + 2, -1);
        guiGraphics.m_280509_(minX - 5, minY - 1, maxX + 5, maxY + 1, backColor);
        guiGraphics.m_280656_(minX, maxX, middleY, lineColor);
        guiGraphics.m_280315_(minX, minY, maxY, lineColor);
        guiGraphics.m_280315_(maxX, minY, maxY, lineColor);
        String minText = this.getValueText(this.minValue);
        guiGraphics.m_280056_(font, minText, minX - font.m_92895_(minText) / 2, this.m_252907_() - 5, lineColor, false);
        String maxText = this.getValueText(this.maxValue);
        guiGraphics.m_280056_(font, maxText, maxX - font.m_92895_(maxText) / 2, this.m_252907_() - 5, lineColor, false);
        String currentText = this.getValueText(this.getValue());
        guiGraphics.m_280056_(font, currentText, middleX - font.m_92895_(currentText) / 2, this.m_252907_() - 5, lineColor, false);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.m_280218_(this.getHandleSprite(), this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_() + 4, 0, 0, 8, this.m_93694_() - 8);
    }

    private String getValueText(double value) {
        if (this.stepSize < 1.0) {
            return String.format("%.1f", value);
        }
        return String.format("%.0f", value);
    }

    protected void m_5697_() {
        this.setter.accept(this.getValue());
    }

    @NotNull
    protected ResourceLocation getHandleSprite() {
        if (this.f_93623_) {
            return this.m_274382_() ? BUTTON_HIGHLIGHTED : BUTTON;
        }
        return BUTTON_DISABLED;
    }
}

