/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.cluster;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.GridCraftingCpuChange;
import appeng.api.networking.events.GridEvent;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCluster;
import net.pedroksl.advanced_ae.common.entities.AdvCraftingBlockEntity;

public class AdvCraftingCPUCalculator
extends MBCalculator<AdvCraftingBlockEntity, AdvCraftingCPUCluster> {
    public AdvCraftingCPUCalculator(AdvCraftingBlockEntity t) {
        super((IAEMultiBlock)t);
    }

    public boolean checkMultiblockScale(BlockPos min, BlockPos max) {
        if (max.m_123341_() - min.m_123341_() > 4) {
            return false;
        }
        if (max.m_123342_() - min.m_123342_() > 4) {
            return false;
        }
        return max.m_123343_() - min.m_123343_() <= 4;
    }

    public AdvCraftingCPUCluster createCluster(ServerLevel level, BlockPos min, BlockPos max) {
        return new AdvCraftingCPUCluster(min, max);
    }

    public boolean verifyInternalStructure(ServerLevel level, BlockPos min, BlockPos max) {
        boolean core = false;
        boolean storage = false;
        boolean entangler = false;
        boolean multi = false;
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            IAEMultiBlock te = (IAEMultiBlock)level.m_7702_(blockPos);
            if (te == null || !te.isValid()) {
                return false;
            }
            if (te instanceof AdvCraftingBlockEntity) {
                AdvCraftingBlockEntity advEntity = (AdvCraftingBlockEntity)te;
                boolean isBoundary = blockPos.m_123341_() == min.m_123341_() || blockPos.m_123342_() == min.m_123342_() || blockPos.m_123343_() == min.m_123343_() || blockPos.m_123341_() == max.m_123341_() || blockPos.m_123342_() == max.m_123342_() || blockPos.m_123343_() == max.m_123343_();
                switch ((AAECraftingUnitType)advEntity.getUnitBlock().type) {
                    case QUANTUM_CORE: {
                        if (min.equals((Object)max)) {
                            return true;
                        }
                        if (!isBoundary && !core) {
                            core = true;
                            break;
                        }
                        return false;
                    }
                    case STRUCTURE: {
                        if (isBoundary) break;
                        return false;
                    }
                    case STORAGE_MULTIPLIER: {
                        if (!isBoundary && !entangler) {
                            entangler = true;
                            break;
                        }
                        return false;
                    }
                    case MULTI_THREADER: {
                        if (!isBoundary && !multi) {
                            multi = true;
                            break;
                        }
                        return false;
                    }
                    default: {
                        if (!isBoundary) break;
                        return false;
                    }
                }
                if (storage) continue;
                storage = advEntity.getStorageBytes() > 0L;
                continue;
            }
            return false;
        }
        return storage && core;
    }

    public void updateBlockEntities(AdvCraftingCPUCluster c, ServerLevel level, BlockPos min, BlockPos max) {
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            AdvCraftingBlockEntity te = (AdvCraftingBlockEntity)level.m_7702_(blockPos);
            te.updateStatus(c);
            c.addBlockEntity(te);
        }
        c.done();
        Iterator<AdvCraftingBlockEntity> i = c.getBlockEntities();
        while (i.hasNext()) {
            AdvCraftingBlockEntity gh = i.next();
            IGridNode n = gh.getGridNode();
            if (n == null) continue;
            IGrid g = n.getGrid();
            g.postEvent((GridEvent)new GridCraftingCpuChange(n));
            return;
        }
    }

    public boolean isValidBlockEntity(BlockEntity te) {
        return te instanceof AdvCraftingBlockEntity;
    }
}

