/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="advanced_ae", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AAEConfig {
    private final ClientConfig client = new ClientConfig();
    private final CommonConfig common = new CommonConfig();
    private static AAEConfig INSTANCE;

    AAEConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.client.spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.common.spec);
    }

    public int getQuantumComputerMaxSize() {
        return (Integer)this.common.quantumComputerMaxSize.get();
    }

    public int getQuantumComputerAcceleratorThreads() {
        return (Integer)this.common.quantumComputerAcceleratorThreads.get();
    }

    public int getQuantumComputerMaxMultiThreaders() {
        return (Integer)this.common.quantumComputerMaxMultiThreaders.get();
    }

    public int getQuantumComputermaxDataEntanglers() {
        return (Integer)this.common.quantumComputerMaxDataEntanglers.get();
    }

    public int getQuantumComputerMultiThreaderMultiplication() {
        return (Integer)this.common.quantumComputerMultiThreaderMultiplication.get();
    }

    public int getQuantumComputerDataEntanglerMultiplication() {
        return (Integer)this.common.quantumComputerDataEntanglerMultiplication.get();
    }

    public int getMaxWalkSpeed() {
        return (Integer)this.common.maxWalkSpeed.get();
    }

    public int getMaxSprintSpeed() {
        return (Integer)this.common.maxSprintSpeed.get();
    }

    public int getMaxStepHeight() {
        return (Integer)this.common.maxStepHeight.get();
    }

    public int getMaxJumpHeight() {
        return (Integer)this.common.maxJumpHeight.get();
    }

    public int getmaxHpBuffer() {
        return (Integer)this.common.hpBufferHearts.get();
    }

    public int getMaxFlightSpeed() {
        return (Integer)this.common.maxFlightSpeed.get();
    }

    public int getEvasionChance() {
        return (Integer)this.common.evasionChance.get();
    }

    public int getMaxMagnetRange() {
        return (Integer)this.common.maxMagnetRange.get();
    }

    public int getStrengthBoost() {
        return (Integer)this.common.strengthBoost.get();
    }

    public int getAttackSpeedBoost() {
        return (Integer)this.common.attackSpeedBoost.get();
    }

    public int getLuckBoost() {
        return (Integer)this.common.luckBoost.get();
    }

    public int getMaxReachBoost() {
        return (Integer)this.common.maxReachBoost.get();
    }

    public int getMaxSwimSpeedBoost() {
        return (Integer)this.common.swimSpeedBoost.get();
    }

    public int getRenegerationPerTick() {
        return (Integer)this.common.regenerationPerTick.get();
    }

    public int getPercentageDamageAbsorption() {
        return (Integer)this.common.percentageDamageAbsorption.get();
    }

    public void save() {
        this.common.spec.save();
        this.client.spec.save();
    }

    public static void register(String mod_id) {
        if (!mod_id.equals("advanced_ae")) {
            throw new IllegalArgumentException();
        }
        INSTANCE = new AAEConfig();
    }

    public static AAEConfig instance() {
        return INSTANCE;
    }

    private static class ClientConfig {
        private final ForgeConfigSpec spec;

        public ClientConfig() {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            this.spec = builder.build();
        }
    }

    private static class CommonConfig {
        private final ForgeConfigSpec spec;
        public final ForgeConfigSpec.IntValue quantumComputerMaxSize;
        public final ForgeConfigSpec.IntValue quantumComputerAcceleratorThreads;
        public final ForgeConfigSpec.IntValue quantumComputerMaxMultiThreaders;
        public final ForgeConfigSpec.IntValue quantumComputerMaxDataEntanglers;
        public final ForgeConfigSpec.IntValue quantumComputerMultiThreaderMultiplication;
        public final ForgeConfigSpec.IntValue quantumComputerDataEntanglerMultiplication;
        public final ForgeConfigSpec.IntValue maxWalkSpeed;
        public final ForgeConfigSpec.IntValue maxSprintSpeed;
        public final ForgeConfigSpec.IntValue maxStepHeight;
        public final ForgeConfigSpec.IntValue maxJumpHeight;
        public final ForgeConfigSpec.IntValue hpBufferHearts;
        public final ForgeConfigSpec.IntValue maxFlightSpeed;
        public final ForgeConfigSpec.IntValue evasionChance;
        public final ForgeConfigSpec.IntValue maxMagnetRange;
        public final ForgeConfigSpec.IntValue strengthBoost;
        public final ForgeConfigSpec.IntValue attackSpeedBoost;
        public final ForgeConfigSpec.IntValue luckBoost;
        public final ForgeConfigSpec.IntValue maxReachBoost;
        public final ForgeConfigSpec.IntValue swimSpeedBoost;
        public final ForgeConfigSpec.IntValue regenerationPerTick;
        public final ForgeConfigSpec.IntValue percentageDamageAbsorption;

        public CommonConfig() {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.push("quantum computer");
            this.quantumComputerMaxSize = CommonConfig.define(builder, "quantumComputerMaxSize", 7, 5, 12, "Define the maximum dimensions of the Quantum Computer Multiblock.");
            this.quantumComputerAcceleratorThreads = CommonConfig.define(builder, "quantumComputerAcceleratorThreads", 8, 4, 16, "Define the maximum amount of multi threaders per Quantum Computer Multiblock.");
            this.quantumComputerMaxMultiThreaders = CommonConfig.define(builder, "quantumComputerMaxMultiThreaders", 1, 1, 2, "Define the maximum amount of multi threaders per Quantum Computer Multiblock.");
            this.quantumComputerMaxDataEntanglers = CommonConfig.define(builder, "quantumComputermaxDataEntanglers", 1, 1, 2, "Define the maximum amount of Data Entanglers per Quantum Computer Multiblock.");
            this.quantumComputerMultiThreaderMultiplication = CommonConfig.define(builder, "quantumComputerMultiThreaderMultiplication", 4, 2, 8, "Define the multiplication factor of the multi threaders.");
            this.quantumComputerDataEntanglerMultiplication = CommonConfig.define(builder, "quantumComputerDataEntanglerMultiplication", 4, 2, 8, "Define the multiplication factor of the data entanglers.");
            builder.pop();
            builder.push("quantum armor");
            this.maxWalkSpeed = CommonConfig.define(builder, "quantumArmorMaxWalkSpeed", 60, 10, 100, "Define the maximum walk speed increase. Values are divided by 10 before use.");
            this.maxSprintSpeed = CommonConfig.define(builder, "quantumArmorMaxSprintSpeed", 80, 10, 150, "Define the maximum sprint speed increase. Values are divided by 10 before use.");
            this.maxStepHeight = CommonConfig.define(builder, "quantumArmorMaxStepHeight", 3, 1, 5, "Define the maximum increase in step height.");
            this.maxJumpHeight = CommonConfig.define(builder, "quantumArmorMaxJumpHeight", 3, 1, 5, "Define the maximum increase in jump height.");
            this.swimSpeedBoost = CommonConfig.define(builder, "quantumArmorSwimSpeedBoost", 80, 10, 150, "Define the maximum swim speed increase. Values are divided by 10 before use.");
            this.hpBufferHearts = CommonConfig.define(builder, "quantumArmorHpBuffer", 20, 5, 50, "Define the HP increased of the HP Buffer card.");
            this.maxFlightSpeed = CommonConfig.define(builder, "quantumArmorMaxFlightSpeed", 10, 1, 15, "Define the maximum speed boost of the Flight Card.");
            this.evasionChance = CommonConfig.define(builder, "quantumArmorEvasionChance", 30, 0, 100, "Define the evasion % chance of the evasion card.");
            this.maxMagnetRange = CommonConfig.define(builder, "quantumArmorMagnetRange", 12, 5, 15, "Define the max range of the magnet card.");
            this.strengthBoost = CommonConfig.define(builder, "quantumArmorStrengthBoost", 10, 5, 50, "Define the Attack Damage boost of the Strength Card.");
            this.attackSpeedBoost = CommonConfig.define(builder, "quantumArmorAttackSpeedBoost", 5, 1, 10, "Define the Attack Speed Damage boost of the Attack Speed Card.");
            this.luckBoost = CommonConfig.define(builder, "quantumArmorLuckBoost", 2, 1, 5, "Define the luck boost of the Luck Card.");
            this.maxReachBoost = CommonConfig.define(builder, "quantumArmorMaxReachBoost", 5, 1, 8, "Define the max additional reach of the Reach Card.");
            this.regenerationPerTick = CommonConfig.define(builder, "quantumArmorRenegerationPerTick", 10, 1, 20, "Define the amount of hearts regenerated per tick with the Regeneration Card. Value will be divided by 10 before use.");
            this.percentageDamageAbsorption = CommonConfig.define(builder, "quantumArmorPercentageDamageAbsorption", 30, 5, 100, "Define the maximum percentage of incoming damage absorbed by the Quantum Armor. This value is still limited by the energy buffer in the equipment.");
            builder.pop();
            this.spec = builder.build();
        }

        private static ForgeConfigSpec.IntValue define(ForgeConfigSpec.Builder builder, String name, int defaultValue, String comment) {
            builder.comment(comment);
            return CommonConfig.define(builder, name, defaultValue);
        }

        private static ForgeConfigSpec.IntValue define(ForgeConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
            builder.comment(comment);
            return CommonConfig.define(builder, name, defaultValue, min, max);
        }

        private static ForgeConfigSpec.IntValue define(ForgeConfigSpec.Builder builder, String name, int defaultValue, int min, int max) {
            return builder.defineInRange(name, defaultValue, min, max);
        }

        private static ForgeConfigSpec.IntValue define(ForgeConfigSpec.Builder builder, String name, int defaultValue) {
            return CommonConfig.define(builder, name, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }
}

