/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.api.features.HotkeyAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AAEHotkeys {
    public static final Map<String, List<HotkeyAction>> REGISTRY = new HashMap<String, List<HotkeyAction>>();

    public static void init() {
    }

    public static synchronized void register(HotkeyAction hotkeyAction, String id) {
        if (REGISTRY.containsKey(id)) {
            REGISTRY.get(id).add(0, hotkeyAction);
        } else {
            REGISTRY.put(id, new ArrayList<HotkeyAction>(List.of(hotkeyAction)));
        }
    }

    public static int getDefaultHotkey(String id) {
        try {
            return Keys.valueOf(id).getDefaultHotkey();
        }
        catch (IllegalArgumentException ignored) {
            return -1;
        }
    }

    public static enum Keys {
        ARMOR_CONFIG("quantum_armor_config", "Open Quantum Armor Configuration", 78),
        PATTERN_ENCODER_HOTKEY("pattern_encoder_action", "Open Advanced Pattern Encoder"),
        QUANTUM_MAGNET_UPGRADE("quantum_magnet_upgrade", "Toggle Quantum Armor Magnet", 71),
        QUANTUM_AUTO_STOCK_UPGRADE("quantum_auto_stock_upgrade", "Toggle Quantum Armor Auto Stock", 74),
        QUANTUM_NIGHT_VISION_UPGRADE("quantum_night_vision_upgrade", "Toggle Quantum Armor Night Vision"),
        PORTABLE_WORKBENCH("portable_workbench", "Open Portable Workbench", 67),
        PICK_CRAFT("pick_craft", "Attempt crafting targeted block", 86);

        private final String id;
        private final String englishTranslation;
        private final int defaultHotkey;

        private Keys(String id, String englishTranslation) {
            this(id, englishTranslation, -1);
        }

        private Keys(String id, String englishTranslation, int defaultHotekey) {
            this.id = id;
            this.englishTranslation = englishTranslation;
            this.defaultHotkey = defaultHotekey;
        }

        public String getId() {
            return this.id;
        }

        public String getEnglishTranslation() {
            return this.englishTranslation;
        }

        public int getDefaultHotkey() {
            return this.defaultHotkey;
        }
    }
}

