/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.entities;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.block.crafting.PatternProviderBlock;
import appeng.block.crafting.PushDirection;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.pedroksl.advanced_ae.common.blocks.AdvPatternProviderBlock;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.logic.AdvPatternProviderLogic;
import net.pedroksl.advanced_ae.common.logic.AdvPatternProviderLogicHost;
import org.jetbrains.annotations.Nullable;

public class AdvPatternProviderEntity
extends AENetworkBlockEntity
implements AdvPatternProviderLogicHost {
    protected final AdvPatternProviderLogic logic;
    @Nullable
    private PushDirection pendingPushDirectionChange;

    public AdvPatternProviderEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        this(blockEntityType, pos, blockState, 36);
    }

    public AdvPatternProviderEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState, int slots) {
        super(blockEntityType, pos, blockState);
        this.logic = this.createLogic(slots);
    }

    protected AdvPatternProviderLogic createLogic(int slots) {
        return new AdvPatternProviderLogic(this.getMainNode(), this, slots);
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.logic.onMainNodeStateChanged();
        this.updateState();
    }

    public void updateState() {
        if (!this.getMainNode().isReady()) {
            return;
        }
        boolean connected = false;
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && grid.getEnergyService().isNetworkPowered()) {
            connected = true;
        }
        if (this.checkPosition(this.f_58858_) && (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)AdvPatternProviderBlock.CONNECTION_STATE) != connected) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)AdvPatternProviderBlock.CONNECTION_STATE, (Comparable)Boolean.valueOf(connected)), 2);
        }
    }

    private boolean checkPosition(BlockPos pos) {
        return Platform.getTickingBlockEntity((Level)this.m_58904_(), (BlockPos)pos) instanceof AdvPatternProviderEntity;
    }

    private PushDirection getPushDirection() {
        return (PushDirection)this.m_58900_().m_61143_((Property)PatternProviderBlock.PUSH_DIRECTION);
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        Direction pushDirection = this.getPushDirection().getDirection();
        if (pushDirection == null) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.complementOf(EnumSet.of(pushDirection));
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        this.logic.addDrops(drops);
    }

    public void m_6211_() {
        super.m_6211_();
        this.logic.clearContent();
    }

    public void onReady() {
        if (this.pendingPushDirectionChange != null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)this.pendingPushDirectionChange));
            this.pendingPushDirectionChange = null;
            this.onGridConnectableSidesChanged();
        }
        super.onReady();
        this.logic.updatePatterns();
        this.updateState();
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.logic.writeToNBT(data);
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        if (data.m_128471_("omniDirectional")) {
            this.pendingPushDirectionChange = PushDirection.ALL;
        } else if (data.m_128425_("forward", 8)) {
            try {
                Direction forward = Direction.valueOf((String)data.m_128461_("forward").toUpperCase(Locale.ROOT));
                this.pendingPushDirectionChange = PushDirection.fromDirection((Direction)forward);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.logic.readFromNBT(data);
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Override
    public AdvPatternProviderLogic getLogic() {
        return this.logic;
    }

    @Override
    public EnumSet<Direction> getTargets() {
        PushDirection pushDirection = this.getPushDirection();
        if (pushDirection.getDirection() == null) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.of(pushDirection.getDirection());
    }

    @Override
    public AEItemKey getTerminalIcon() {
        return AEItemKey.of(AAEBlocks.ADV_PATTERN_PROVIDER);
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output, @Nullable Player player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.exportSettings(output);
            PushDirection pushDirection = this.getPushDirection();
            output.m_128344_("push_direction", (byte)pushDirection.ordinal());
        }
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            Level level;
            byte pushDirection;
            this.logic.importSettings(input, player);
            if (input.m_128425_(PatternProviderBlock.PUSH_DIRECTION.m_61708_(), 1) && (pushDirection = input.m_128445_(PatternProviderBlock.PUSH_DIRECTION.m_61708_())) >= 0 && pushDirection < PushDirection.values().length && (level = this.m_58904_()) != null) {
                level.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)PushDirection.values()[pushDirection]));
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @javax.annotation.Nullable Direction side) {
        LazyOptional<T> lo = this.logic.getCapability(cap);
        if (lo.isPresent()) {
            return lo;
        }
        return super.getCapability(cap, side);
    }

    public ItemStack getMainMenuIcon() {
        return AAEBlocks.ADV_PATTERN_PROVIDER.stack();
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.onGridConnectableSidesChanged();
    }

    @Override
    public void openMenu(Player player, MenuLocator locator) {
        MenuOpener.open(AAEMenus.ADV_PATTERN_PROVIDER, (Player)player, (MenuLocator)locator);
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(AAEMenus.ADV_PATTERN_PROVIDER, (Player)player, (MenuLocator)subMenu.getLocator());
    }
}

