/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items;

import appeng.api.parts.IPart;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.parts.AEBasePart;
import appeng.parts.crafting.PatternProviderPart;
import com.glodblock.github.extendedae.common.parts.PartExPatternProvider;
import com.glodblock.github.extendedae.common.tileentities.TileExPatternProvider;
import com.glodblock.github.extendedae.util.FCUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.parts.AdvPatternProviderPart;
import org.jetbrains.annotations.Nullable;

public class AdvPatternProviderUpgradeItem
extends Item {
    public AdvPatternProviderUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity entity = world.m_7702_(pos);
        if (entity == null) return InteractionResult.PASS;
        BlockPlaceContext ctx = new BlockPlaceContext(context);
        Class<?> tClazz = entity.getClass();
        if (tClazz == PatternProviderBlockEntity.class || tClazz == TileExPatternProvider.class) {
            BlockState state;
            BlockState originState = world.m_8055_(pos);
            boolean isSmall = tClazz == PatternProviderBlockEntity.class;
            BlockState blockState = state = isSmall ? AAEBlocks.SMALL_ADV_PATTERN_PROVIDER.block().m_5573_(ctx) : AAEBlocks.ADV_PATTERN_PROVIDER.block().m_5573_(ctx);
            if (state == null) {
                return InteractionResult.PASS;
            }
            for (Map.Entry sp : originState.m_61148_().entrySet()) {
                Property pt = (Property)sp.getKey();
                Comparable va = (Comparable)sp.getValue();
                try {
                    if (!state.m_61138_(pt)) continue;
                    state = (BlockState)state.m_61124_(pt, va);
                }
                catch (Exception exception) {}
            }
            Object object = isSmall ? AAEBlockEntities.SMALL_ADV_PATTERN_PROVIDER.get() : AAEBlockEntities.ADV_PATTERN_PROVIDER.get();
            BlockEntity te = object.m_155264_(pos, state);
            FCUtil.replaceTile((Level)world, (BlockPos)pos, (BlockEntity)entity, (BlockEntity)te, (BlockState)state);
            context.m_43722_().m_41774_(1);
            return InteractionResult.CONSUME;
        }
        if (!(entity instanceof CableBusBlockEntity)) return InteractionResult.PASS;
        CableBusBlockEntity cable = (CableBusBlockEntity)entity;
        Vec3 hitVec = context.m_43720_();
        Vec3 hitInBlock = new Vec3(hitVec.f_82479_ - (double)pos.m_123341_(), hitVec.f_82480_ - (double)pos.m_123342_(), hitVec.f_82481_ - (double)pos.m_123343_());
        IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
        if (!(part instanceof AEBasePart)) return InteractionResult.PASS;
        AEBasePart aEBasePart = (AEBasePart)part;
        if (part.getClass() != PatternProviderPart.class && part.getClass() != PartExPatternProvider.class) return InteractionResult.PASS;
        Direction side = aEBasePart.getSide();
        CompoundTag contents = new CompoundTag();
        boolean isSmall = part.getClass() == PatternProviderPart.class;
        Object object = isSmall ? AAEItems.SMALL_ADV_PATTERN_PROVIDER.get() : AAEItems.ADV_PATTERN_PROVIDER.get();
        part.writeToNBT(contents);
        AdvPatternProviderPart p = (AdvPatternProviderPart)cable.replacePart(object, side, context.m_43723_(), null);
        if (p != null) {
            p.readFromNBT(contents);
        }
        context.m_43722_().m_41774_(1);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237119_().m_7220_((Component)AAEText.PatternProviderUpgrade.text().m_130940_(AAEText.TOOLTIP_DEFAULT_COLOR)));
    }
}

