/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.parts;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.ISubMenuHost;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.HandlerStrategy;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.ConfigInventory;
import com.glodblock.github.glodium.reflect.ReflectKit;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.helpers.SimulatedStorageImportStrategy;

public class StockExportBusPart
extends ExportBusPart
implements ISubMenuHost {
    public static final ResourceLocation MODEL_BASE = AdvancedAE.makeId("part/stock_export_bus_part");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_has_channel")});
    private static final Method createTransferContext;
    private static final Method updateState;
    private ConfigInventory config;
    private SimulatedStorageImportStrategy<IItemHandler, ItemStack> itemImportStrategy;
    private SimulatedStorageImportStrategy<IFluidHandler, FluidStack> fluidImportStrategy;

    public StockExportBusPart(IPartItem<?> partItem) {
        super(partItem);
    }

    public void readFromNBT(CompoundTag extra) {
        super.readFromNBT(extra);
        this.config.readFromChildTag(extra, "extraConfig");
    }

    public void writeToNBT(CompoundTag extra) {
        super.writeToNBT(extra);
        this.config.writeToChildTag(extra, "extraConfig");
    }

    public ConfigInventory getConfig() {
        if (this.config == null) {
            this.config = ConfigInventory.configStacks((AEKeyFilter)StackWorldBehaviors.hasExportStrategyFilter(), (int)63, () -> StockExportBusPart.updatePartState((IOBusPart)this), (boolean)true);
        }
        return this.config;
    }

    private void getStrategies() {
        BlockEntity self = this.getHost().getBlockEntity();
        BlockPos fromPos = self.m_58899_().m_121945_(this.getSide());
        Direction fromSide = this.getSide().m_122424_();
        if (this.itemImportStrategy == null) {
            this.itemImportStrategy = new SimulatedStorageImportStrategy(ForgeCapabilities.ITEM_HANDLER, HandlerStrategy.ITEMS, (ServerLevel)this.getLevel(), fromPos, fromSide);
        }
        if (this.fluidImportStrategy == null) {
            this.fluidImportStrategy = new SimulatedStorageImportStrategy(ForgeCapabilities.FLUID_HANDLER, HandlerStrategy.FLUIDS, (ServerLevel)this.getLevel(), fromPos, fromSide);
        }
    }

    protected boolean doBusWork(IGrid grid) {
        int x;
        IStorageService storageService = grid.getStorageService();
        ICraftingService cg = grid.getCraftingService();
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        StackTransferContext context = StockExportBusPart.getStackTransferContext(this, storageService, grid.getEnergyService());
        for (x = 0; x < this.availableSlots() && context.hasOperationsLeft(); ++x) {
            int slotToExport = this.getStartingSlot(schedulingMode, x);
            GenericStack stack = this.getConfig().getStack(slotToExport);
            if (stack == null || stack.what() == null) continue;
            AEKey what = stack.what();
            int amount = (int)stack.amount();
            if (this.craftOnly()) {
                this.attemptCrafting(context, cg, slotToExport, what, amount);
                continue;
            }
            int before = context.getOperationsRemaining();
            int transferFactor = what.getAmountPerOperation();
            long maxAmount = (long)context.getOperationsRemaining() * (long)transferFactor;
            long currentAmount = this.getCurrentStock(context, what, amount);
            maxAmount = Math.min(maxAmount, (long)amount - currentAmount);
            long transferred = this.getExportStrategy().transfer(context, what, maxAmount);
            if (transferred > 0L) {
                context.reduceOperationsRemaining(Math.max(1L, transferred / (long)transferFactor));
            }
            if (before != context.getOperationsRemaining() || !this.isCraftingEnabled()) continue;
            this.attemptCrafting(context, cg, slotToExport, what, amount);
        }
        if (context.hasDoneWork()) {
            this.updateSchedulingMode(schedulingMode, x);
        }
        return context.hasDoneWork();
    }

    private boolean craftOnly() {
        return this.isCraftingEnabled() && this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.isUpgradedWith((ItemLike)AEItems.CRAFTING_CARD);
    }

    private void attemptCrafting(StackTransferContext context, ICraftingService cg, int slotToExport, AEKey what, long targetAmount) {
        long maxAmount = (long)context.getOperationsRemaining() * (long)what.getAmountPerOperation();
        long currentAmount = this.getCurrentStock(context, what, targetAmount);
        maxAmount = Math.min(maxAmount, targetAmount - currentAmount);
        long amount = this.getExportStrategy().push(what, maxAmount, Actionable.SIMULATE);
        if (amount > 0L) {
            this.requestCrafting(cg, slotToExport, what, amount);
            context.reduceOperationsRemaining(Math.max(1L, amount / (long)what.getAmountPerOperation()));
        }
    }

    private long getCurrentStock(StackTransferContext context, AEKey what, long targetAmount) {
        this.getStrategies();
        return this.itemImportStrategy.simulateTransfer(what, targetAmount, context.getActionSource()) + this.fluidImportStrategy.simulateTransfer(what, targetAmount, context.getActionSource());
    }

    public static void updatePartState(IOBusPart owner) {
        ReflectKit.executeMethod((Object)owner, (Method)updateState, (Object[])new Object[0]);
    }

    protected MenuType<?> getMenuType() {
        return AAEMenus.STOCK_EXPORT_BUS;
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.open(AAEMenus.STOCK_EXPORT_BUS, (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public ItemStack getMainMenuIcon() {
        return this.getPartItem().m_5456_().m_7968_();
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    private static StackTransferContext getStackTransferContext(ExportBusPart part, IStorageService storageService, IEnergyService energyService) {
        return (StackTransferContext)ReflectKit.executeMethod2((Object)part, (Method)createTransferContext, (Object[])new Object[]{storageService, energyService});
    }

    static {
        try {
            updateState = ReflectKit.reflectMethod(IOBusPart.class, (String)"updateState", (Class[])new Class[0]);
            createTransferContext = ReflectKit.reflectMethod(ExportBusPart.class, (String)"createTransferContext", (Class[])new Class[]{IStorageService.class, IEnergyService.class});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Reflection failed", e);
        }
    }
}

