/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.ae2.ManaKey;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.StorageCell;
import appeng.items.tools.powered.AbstractPortableCell;
import com.google.common.primitives.Ints;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItem;

public class MEStorageManaItem
implements ManaItem {
    private final MEStorage storage;
    private final IEnergySource energy;
    private final IActionSource source;

    public MEStorageManaItem(MEStorage storage, IEnergySource energy, IActionSource source) {
        this.storage = storage;
        this.energy = energy;
        this.source = source;
    }

    @Nullable
    public static ManaItem forItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof AbstractPortableCell) {
            AbstractPortableCell item2 = (AbstractPortableCell)item;
            StorageCell storage = StorageCells.getCellInventory((ItemStack)stack, null);
            if (storage == null) {
                return null;
            }
            return new MEStorageManaItem((MEStorage)storage, (amount, mode, multiplier) -> {
                amount = multiplier.multiply(amount);
                if (mode == Actionable.SIMULATE) {
                    return multiplier.divide(Math.min(amount, item2.getAECurrentPower(stack)));
                }
                return multiplier.divide(item2.extractAEPower(stack, amount, Actionable.MODULATE));
            }, IActionSource.empty());
        }
        return null;
    }

    public int getMana() {
        return (int)StorageHelper.poweredExtraction((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)Integer.MAX_VALUE, (IActionSource)this.source, (Actionable)Actionable.SIMULATE);
    }

    public int getMaxMana() {
        return Ints.saturatedCast((long)(StorageHelper.poweredExtraction((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)Integer.MAX_VALUE, (IActionSource)this.source, (Actionable)Actionable.SIMULATE) + StorageHelper.poweredInsert((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)Integer.MAX_VALUE, (IActionSource)this.source, (Actionable)Actionable.SIMULATE)));
    }

    public void addMana(int mana) {
        if (mana > 0) {
            StorageHelper.poweredInsert((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)mana, (IActionSource)this.source);
        } else {
            StorageHelper.poweredExtraction((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)(-mana), (IActionSource)this.source);
        }
    }

    public boolean canReceiveManaFromPool(BlockEntity pool) {
        return true;
    }

    public boolean canReceiveManaFromItem(ItemStack otherStack) {
        return true;
    }

    public boolean canExportManaToPool(BlockEntity pool) {
        return true;
    }

    public boolean canExportManaToItem(ItemStack otherStack) {
        return true;
    }

    public boolean isNoExport() {
        return false;
    }
}

