/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import me.cg360.mod.bridging.raytrace.PathTraversalHandler;
import me.cg360.mod.bridging.util.GameSupport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class Render {
    public static void blocksInViewPath(PoseStack poseStack, VertexConsumer vertexConsumer, Camera camera) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        List<BlockPos> path = PathTraversalHandler.getViewBlockPath((Entity)player, camera);
        if (path.isEmpty()) {
            return;
        }
        for (BlockPos pos : path) {
            Render.cubeTrace(poseStack, vertexConsumer, camera, pos);
        }
    }

    public static void cubeHighlight(PoseStack poseStack, VertexConsumer vertices, Camera camera, BlockPos pos) {
        Render.cubeOutline(poseStack, vertices, camera, pos, 637573631);
    }

    public static void cubeTrace(PoseStack poseStack, VertexConsumer vertices, Camera camera, BlockPos pos) {
        Render.cubeOutline(poseStack, vertices, camera, pos, 0x16333333);
    }

    public static void cubeTermination(PoseStack poseStack, VertexConsumer vertices, Camera camera, BlockPos pos) {
        Render.cubeOutline(poseStack, vertices, camera, pos, 0x7FFF0000);
    }

    public static void cubeOutline(PoseStack poseStack, VertexConsumer consumer, Camera camera, BlockPos pos, int argbColor) {
        PoseStack.Pose pose = poseStack.m_85850_();
        Vec3 camPos = camera.m_90583_();
        double x = (double)pos.m_123341_() - camPos.m_7096_();
        double y = (double)pos.m_123342_() - camPos.m_7098_();
        double z = (double)pos.m_123343_() - camPos.m_7094_();
        Shapes.m_83144_().m_83224_((startX, startY, startZ, endX, endY, endZ) -> {
            float dx = (float)(endX - startX);
            float dy = (float)(endY - startY);
            float dz = (float)(endZ - startZ);
            float length = Mth.m_14116_((float)(dx * dx + dy * dy + dz * dz));
            consumer.m_252986_(pose.m_252922_(), (float)(startX + x), (float)(startY + y), (float)(startZ + z)).m_193479_(argbColor).m_252939_(pose.m_252943_(), dx /= length, dy /= length, dz /= length).m_5752_();
            consumer.m_252986_(pose.m_252922_(), (float)(endX + x), (float)(endY + y), (float)(endZ + z)).m_193479_(argbColor).m_252939_(pose.m_252943_(), dx, dy, dz).m_5752_();
        });
    }

    public static void currentNonBridgingOutline(PoseStack poseStack, Camera camera, VertexConsumer vertices) {
        HitResult hit = Minecraft.m_91087_().f_91077_;
        if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hit;
        BlockPos hitBlock = blockHitResult.m_82425_();
        Direction hitSide = blockHitResult.m_82434_();
        BlockPos placeTarget = hitBlock.m_121945_(hitSide);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!GameSupport.isHoldingPlaceable((Player)player)) {
            return;
        }
        AABB placeDeadzone = new AABB(placeTarget);
        if (player.m_20191_().m_82381_(placeDeadzone)) {
            return;
        }
        int outlineColour = BridgingMod.getConfig().getOutlineColour().getRGB();
        Render.cubeOutline(poseStack, vertices, camera, placeTarget, outlineColour);
    }

    public static void currentBridgingOutline(PoseStack poseStack, Camera camera, VertexConsumer vertices) {
        Tuple<BlockPos, Direction> lastTarget = BridgingStateTracker.getLastTickTarget();
        if (lastTarget == null) {
            return;
        }
        int outlineColour = BridgingMod.getConfig().getOutlineColour().getRGB();
        Render.cubeOutline(poseStack, vertices, camera, (BlockPos)lastTarget.m_14418_(), outlineColour);
    }
}

