/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine;

import dev.shadowsoffire.placebo.config.Configuration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ClickMachineConfig {
    public static int[] speeds = new int[]{500, 200, 100, 50, 20, 10, 5, 2, 1};
    public static boolean usesRF = false;
    public static int maxPowerStorage = 50000;
    public static int[] powerPerSpeed = new int[]{0, 3, 5, 10, 25, 50, 100, 250, 500};
    public static Set<Item> blacklistedItems = new HashSet<Item>();

    public static void init(Configuration cfg) {
        int i2;
        String[] def = new String[9];
        for (int i3 = 0; i3 < 9; ++i3) {
            def[i3] = Integer.valueOf(speeds[i3]).toString();
        }
        String[] unparsed = cfg.getStringList("Speeds", "general", def, "The possible speeds of the auto clicker, from 0-8.  Must have 9 values.");
        for (i2 = 0; i2 < 9; ++i2) {
            ClickMachineConfig.speeds[i2] = Integer.parseInt(unparsed[i2]);
        }
        usesRF = cfg.getBoolean("Uses RF", "general", usesRF, "If the auto clicker uses RF");
        def = new String[9];
        for (i2 = 0; i2 < 9; ++i2) {
            def[i2] = Integer.valueOf(powerPerSpeed[i2]).toString();
        }
        unparsed = cfg.getStringList("RF Costs", "general", def, "The RF cost per tick for each speed, from 0-8.  Must have 9 values.  Unused if \"Uses RF\" = false");
        for (i2 = 0; i2 < 9; ++i2) {
            ClickMachineConfig.powerPerSpeed[i2] = Integer.parseInt(unparsed[i2]);
        }
        maxPowerStorage = cfg.getInt("Max Power Storage", "general", maxPowerStorage, 0, Integer.MAX_VALUE, "How much power the auto clicker can store.  Also the max input rate.  Unused if \"Uses RF\" = false");
        String[] blacklist = cfg.getStringList("Item Blacklist", "general", new String[]{"minecraft:bedrock"}, "Items that may not be held by the clicker");
        blacklistedItems = Arrays.stream(blacklist).map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).filter(i -> !Items.f_41852_.equals(i)).collect(Collectors.toSet());
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }
}

