/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine.block;

import com.mojang.authlib.GameProfile;
import dev.shadowsoffire.clickmachine.ClickMachine;
import dev.shadowsoffire.clickmachine.ClickMachineConfig;
import dev.shadowsoffire.clickmachine.block.AutoClickerBlock;
import dev.shadowsoffire.clickmachine.util.FakePlayerUtil;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AutoClickerTile
extends BlockEntity
implements Consumer<ItemStack>,
TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister {
    public static final GameProfile DEFAULT_CLICKER = new GameProfile(UUID.fromString("36f373ac-29ef-4150-b664-e7e6006efcd8"), "[The Click Machine]");
    ItemStackHandler held;
    ModifiableEnergyStorage power = new ModifiableEnergyStorage(ClickMachineConfig.maxPowerStorage);
    int speedIdx = 0;
    boolean sneak = false;
    boolean rightClick = true;
    GameProfile profile;
    FakePlayerUtil.UsefulFakePlayer player;
    int counter = 0;
    protected final SimpleDataSlots data = new SimpleDataSlots();
    LazyOptional<IItemHandler> ihopt = LazyOptional.of(() -> this.held);
    LazyOptional<IEnergyStorage> ieopt = LazyOptional.of(() -> this.power);
    static final String tagUUID = "uuid";
    static final String tagName = "name";
    static final String tagCounter = "counter";
    static final String tagSpeed = "speed_index";
    static final String tagSneak = "sneak";
    static final String tagRightClick = "right_click";
    static final String tagHandler = "inv";
    static final String tagEnergy = "fe";

    public AutoClickerTile(BlockPos pos, BlockState state) {
        super(ClickMachine.AUTO_CLICKER_TILE, pos, state);
        this.held = new ItemStackHandler(1){

            public boolean isItemValid(int slot, ItemStack stack) {
                return !ClickMachineConfig.blacklistedItems.contains(stack.m_41720_());
            }
        };
        this.data.addEnergy(this.power);
        this.data.addData(() -> this.speedIdx, v -> {
            this.speedIdx = v;
        });
        this.data.addData(() -> this.sneak, v -> {
            this.sneak = v;
        });
        this.data.addData(() -> this.rightClick, v -> {
            this.rightClick = v;
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.player == null) {
            this.player = FakePlayerUtil.createPlayer(level, this.profile != null ? this.profile : DEFAULT_CLICKER);
        }
        if (!level.m_276867_(this.f_58858_)) {
            int use;
            int n = use = ClickMachineConfig.usesRF ? ClickMachineConfig.powerPerSpeed[this.getSpeedIndex()] : 0;
            if (this.power.extractEnergy(use, true) == use) {
                this.power.extractEnergy(use, false);
                if (this.counter++ % this.getSpeed() == 0) {
                    Direction facing = (Direction)level.m_8055_(this.f_58858_).m_61143_((Property)AutoClickerBlock.FACING);
                    FakePlayerUtil.setupFakePlayerForUse(this.getPlayer(), this.f_58858_, facing, this.held.getStackInSlot(0).m_41777_(), this.sneak);
                    ItemStack result = this.held.getStackInSlot(0);
                    result = this.rightClick ? FakePlayerUtil.rightClickInDirection(this.getPlayer(), this.f_58857_, this.f_58858_, facing, level.m_8055_(this.f_58858_)) : FakePlayerUtil.leftClickInDirection(this.getPlayer(), this.f_58857_, this.f_58858_, facing, level.m_8055_(this.f_58858_));
                    FakePlayerUtil.cleanupFakePlayerFromUse(this.getPlayer(), result, this.held.getStackInSlot(0), this);
                    this.m_6596_();
                }
            }
            if (!((Boolean)state.m_61143_((Property)AutoClickerBlock.ACTIVE)).booleanValue()) {
                level.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)AutoClickerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
            }
        } else if (((Boolean)state.m_61143_((Property)AutoClickerBlock.ACTIVE)).booleanValue()) {
            level.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)AutoClickerBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
        this.player.m_36335_().m_41518_();
    }

    public void setPlayer(Player player) {
        this.profile = player.m_36316_();
        this.m_6596_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.ihopt.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && ClickMachineConfig.usesRF) {
            return this.ieopt.cast();
        }
        return super.getCapability(cap, side);
    }

    FakePlayerUtil.UsefulFakePlayer getPlayer() {
        return this.player;
    }

    public IItemHandler getHandler() {
        return this.held;
    }

    public int getSpeed() {
        return ClickMachineConfig.speeds[this.getSpeedIndex()];
    }

    public int getSpeedIndex() {
        return this.speedIdx;
    }

    public void setSpeedIndex(int speedIdx) {
        this.speedIdx = speedIdx;
        this.m_6596_();
    }

    public boolean isSneaking() {
        return this.sneak;
    }

    public void setSneaking(boolean sneak) {
        this.sneak = sneak;
        this.m_6596_();
    }

    public boolean isRightClicking() {
        return this.rightClick;
    }

    public void setRightClicking(boolean rightClick) {
        this.rightClick = rightClick;
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.profile != null) {
            tag.m_128362_(tagUUID, this.profile.getId());
            tag.m_128359_(tagName, this.profile.getName());
        }
        tag.m_128365_(tagHandler, (Tag)this.held.serializeNBT());
        tag.m_128405_(tagCounter, this.counter % this.getSpeed());
        this.writeSyncData(tag);
    }

    CompoundTag writeSyncData(CompoundTag tag) {
        tag.m_128405_(tagSpeed, this.getSpeedIndex());
        tag.m_128379_(tagSneak, this.sneak);
        tag.m_128379_(tagRightClick, this.rightClick);
        tag.m_128405_(tagEnergy, this.power.getEnergyStored());
        return tag;
    }

    void readSyncData(CompoundTag tag) {
        this.setSpeedIndex(tag.m_128451_(tagSpeed));
        this.sneak = tag.m_128471_(tagSneak);
        this.rightClick = tag.m_128471_(tagRightClick);
        this.setPower(tag.m_128451_(tagEnergy));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(tagUUID) && tag.m_128441_(tagName)) {
            this.profile = new GameProfile(tag.m_128342_(tagUUID), tag.m_128461_(tagName));
        }
        if (tag.m_128441_(tagHandler)) {
            this.held.deserializeNBT(tag.m_128469_(tagHandler));
        }
        this.counter = tag.m_128451_(tagCounter);
        this.readSyncData(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, b -> ((AutoClickerTile)b).writeSyncData(new CompoundTag()));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readSyncData(pkt.m_131708_());
    }

    public int getPower() {
        return this.power.getEnergyStored();
    }

    public void setPower(int energy) {
        this.power.extractEnergy(this.power.getMaxEnergyStored(), false);
        this.power.receiveEnergy(energy, false);
        this.m_6596_();
    }

    @Override
    public void accept(ItemStack s) {
        this.held.setStackInSlot(0, s);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }
}

