/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine.block.gui;

import dev.shadowsoffire.clickmachine.ClickMachineConfig;
import dev.shadowsoffire.clickmachine.block.gui.AutoClickContainer;
import dev.shadowsoffire.clickmachine.block.gui.AutoClickScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SpeedSlider
extends AbstractSliderButton {
    protected static final int minValue = 0;
    protected static final int maxValue = 8;
    protected static final float stepSize = 0.11111111f;
    protected final AutoClickScreen gui;

    public SpeedSlider(AutoClickScreen gui, int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.f_237098_, SpeedSlider.normalizeValue(((AutoClickContainer)gui.m_6262_()).getSpeedIdx()));
        this.gui = gui;
        this.m_5695_();
    }

    protected void m_5695_() {
        int spd = SpeedSlider.denormalizeValue(this.f_93577_);
        int ticksPerClick = ClickMachineConfig.speeds[spd];
        double cps = 1.0 / (double)ticksPerClick * 20.0;
        this.m_93666_((Component)Component.m_237110_((String)"gui.clickmachine.speed", (Object[])new Object[]{String.format("%.2f", cps)}));
    }

    protected void m_5697_() {
        Minecraft.m_91087_().f_91072_.m_105208_(((AutoClickContainer)this.gui.m_6262_()).f_38840_, 4 + SpeedSlider.denormalizeValue(this.f_93577_));
    }

    public void setValue(int value) {
        if (!this.gui.m_7282_()) {
            this.f_93577_ = SpeedSlider.normalizeValue(value);
            this.m_5695_();
        }
    }

    public static double normalizeValue(double value) {
        return Mth.m_14008_((double)((SpeedSlider.snapToStepClamp(value) - 0.0) / 8.0), (double)0.0, (double)1.0);
    }

    public static int denormalizeValue(double value) {
        return (int)SpeedSlider.snapToStepClamp(Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)0.0, (double)8.0));
    }

    private static double snapToStepClamp(double valueIn) {
        valueIn = 0.11111111f * (float)Math.round(valueIn / 0.1111111119389534);
        return Mth.m_14008_((double)valueIn, (double)0.0, (double)8.0);
    }
}

