/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.utils.LogHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public abstract class TileReactorComponent
extends TileBCore {
    private final ManagedVec3I coreOffset = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("core_offset", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedEnum<Direction> facing = (ManagedEnum)this.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.UP, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isBound = (ManagedBool)this.register((IManagedData)new ManagedBool("is_bound", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedEnum<RSMode> rsMode = (ManagedEnum)this.register((IManagedData)new ManagedEnum("rs_mode", (Enum)RSMode.TEMP, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedInt rsPower = (ManagedInt)this.register((IManagedData)new ManagedInt("rs_power", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public float animRotation = 0.0f;
    public float animRotationSpeed = 0.0f;
    private TileReactorCore cachedCore = null;
    public boolean coreFalureIminent = false;
    private boolean moveCheckComplete = false;

    public TileReactorComponent(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public int getAccessDistanceSq() {
        return 256;
    }

    public void tick() {
        super.tick();
        this.moveCheckComplete = false;
        if (this.f_58857_.f_46443_) {
            TileReactorCore core = this.tryGetCore();
            if (core != null) {
                this.animRotationSpeed = core.shieldAnimationState * 15.0f;
                this.coreFalureIminent = core.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE;
            } else {
                this.coreFalureIminent = false;
                this.animRotationSpeed = 0.0f;
            }
            this.animRotation += this.animRotationSpeed;
            if (this.coreFalureIminent && this.f_58857_.f_46441_.m_188503_(10) == 0) {
                this.animRotation = (float)((double)this.animRotation + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 360.0);
                if (this.f_58857_.f_46441_.m_188499_()) {
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
                } else {
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            int rs;
            TileReactorCore core = this.getCachedCore();
            if (core != null && (rs = ((RSMode)this.rsMode.get()).getRSSignal(core)) != this.rsPower.get()) {
                this.rsPower.set(rs);
                this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    public void bindToCore(TileReactorCore core) {
        LogHelper.dev("Reactor-Comp: Bind To Core");
        this.isBound.set(true);
        this.coreOffset.set(this.getCoreOffset(core.m_58899_()));
    }

    public void pokeCore() {
        TileReactorCore core;
        LogHelper.dev("Reactor-Comp: Try Poke Core");
        if (this.isBound.get() && (core = this.checkAndGetCore()) != null) {
            core.pokeCore(this, ((Direction)this.facing.get()).m_122424_());
            return;
        }
        LogHelper.dev("Reactor-Comp: Try Poke Core | Find");
        for (int i = 1; i < 8; ++i) {
            BlockPos searchPos = this.f_58858_.m_5484_((Direction)this.facing.get(), i);
            if (this.f_58857_.m_46859_(searchPos)) continue;
            BlockEntity tile = this.f_58857_.m_7702_(searchPos);
            LogHelper.dev("Reactor-Comp: Check: " + tile);
            LogHelper.dev("Reactor-Comp: Try Poke Core | Found: " + tile);
            if (tile instanceof TileReactorCore && i > 1) {
                ((TileReactorCore)tile).pokeCore(this, ((Direction)this.facing.get()).m_122424_());
            }
            return;
        }
    }

    public void invalidateComponent() {
        this.isBound.set(false);
    }

    public void onPlaced() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.pokeCore();
    }

    public void onBroken() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        TileReactorCore core = this.checkAndGetCore();
        if (core != null) {
            core.componentBroken(this, ((Direction)this.facing.get()).m_122424_());
        }
    }

    public void onActivated(Player player) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.pokeCore();
        TileReactorCore core = this.checkAndGetCore();
        if (core != null) {
            core.onComponentClicked(player, this);
        }
    }

    public void setRSMode(Player player, RSMode rsMode) {
        if (this.f_58857_.f_46443_) {
            TileReactorCore core = this.tryGetCore();
            if (core != null) {
                core.sendPacketToServer(output -> output.writeString(rsMode.name()).writePos(this.m_58899_()), 99);
            }
        } else {
            this.rsMode.set((Enum)rsMode);
        }
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        if (id == 0) {
            this.setRSMode((Player)client, RSMode.valueOf(data.readString()));
        }
    }

    protected BlockPos getCorePos() {
        return this.f_58858_.m_121996_((Vec3i)this.coreOffset.get().getPos());
    }

    protected Vec3I getCoreOffset(BlockPos corePos) {
        return new Vec3I(this.f_58858_.m_121996_((Vec3i)corePos));
    }

    protected TileReactorCore checkAndGetCore() {
        if (!this.isBound.get()) {
            LogHelper.dev("Reactor-Comp: Not Bound");
            return null;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.getCorePos());
        if (tile instanceof TileReactorCore) {
            return (TileReactorCore)tile;
        }
        if (this.f_58857_.isAreaLoaded(this.getCorePos(), 16)) {
            this.invalidateComponent();
        }
        LogHelper.dev("Reactor-Comp: Core Connection Lost");
        return null;
    }

    public TileReactorCore tryGetCore() {
        if (!this.isBound.get()) {
            return null;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.getCorePos());
        if (tile instanceof TileReactorCore) {
            return (TileReactorCore)tile;
        }
        return null;
    }

    public TileReactorCore getCachedCore() {
        if (this.isBound.get()) {
            BlockPos corePos = this.getCorePos();
            LevelChunk coreChunk = this.f_58857_.m_46745_(corePos);
            if (!this.f_58857_.m_46749_(corePos)) {
                this.cachedCore = null;
                return null;
            }
            BlockEntity tileAtPos = coreChunk.m_5685_(corePos, LevelChunk.EntityCreationType.CHECK);
            if (tileAtPos == null || this.cachedCore == null || tileAtPos != this.cachedCore || tileAtPos.m_58901_()) {
                BlockEntity tile = this.f_58857_.m_7702_(corePos);
                if (tile instanceof TileReactorCore) {
                    this.cachedCore = (TileReactorCore)tile;
                } else {
                    this.cachedCore = null;
                    this.isBound.set(false);
                }
            }
        }
        return this.cachedCore;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RSMode {
        TEMP{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return (int)(tile.temperature.get() / 10000.0 * 15.0);
            }
        }
        ,
        TEMP_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - TEMP.getRSSignal(tile);
            }
        }
        ,
        FIELD{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                double value = tile.shieldCharge.get() / tile.maxShieldCharge.get();
                value -= 0.05;
                return (int)((value *= 1.2) * 15.0);
            }
        }
        ,
        FIELD_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - FIELD.getRSSignal(tile);
            }
        }
        ,
        SAT{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return (int)((double)tile.saturation.get() / (double)tile.maxSaturation.get() * 15.0);
            }
        }
        ,
        SAT_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - SAT.getRSSignal(tile);
            }
        }
        ,
        FUEL{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                double value = tile.convertedFuel.get() / (tile.convertedFuel.get() + tile.reactableFuel.get());
                value += 0.1;
                value = MathUtils.map((double)value, (double)0.1, (double)1.0, (double)0.0, (double)1.0);
                return (int)(value * 15.0);
            }
        }
        ,
        FUEL_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - FUEL.getRSSignal(tile);
            }
        };


        public abstract int getRSSignal(TileReactorCore var1);
    }
}

