/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.inventory.DisenchanterMenu;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class TileDisenchanter
extends TileBCore
implements MenuProvider,
IInteractTile {
    public TileItemStackHandler itemHandler = new TileItemStackHandler((BlockEntity)this, 3).setSlotValidator(0, stack -> stack.m_41793_() && ModHelper.canRemoveEnchants(stack)).setSlotValidator(1, itemStack -> itemStack.m_150930_(Items.f_42517_));

    public TileDisenchanter(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_DISENCHANTER.get(), pos, state);
        this.capManager.setManaged("inventory", ForgeCapabilities.ITEM_HANDLER, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth();
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int pid) {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack books = this.itemHandler.getStackInSlot(1);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        if (input.m_41619_() || !input.m_41793_() || books.m_41619_() || books.m_41613_() <= 0 || !output.m_41619_()) {
            return;
        }
        ListTag list = input.m_41785_();
        if (list.isEmpty()) {
            return;
        }
        String targetId = data.readString();
        if (StringUtils.isEmpty((CharSequence)targetId)) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackCompound;
            CompoundTag compound = list.m_128728_(i);
            String id = compound.m_128461_("id");
            short lvl = compound.m_128448_("lvl");
            Enchantment e = this.getEnchantmentFromTag(compound);
            if (e == null || !id.equals(targetId)) continue;
            int cost = this.getCostInLevels(e, lvl);
            if (!client.m_150110_().f_35937_ && cost > client.f_36078_) {
                client.m_213846_((Component)Component.m_237110_((String)"disenchanter.draconicevolution.not_enough_levels", (Object[])new Object[]{cost}).m_130940_(ChatFormatting.RED));
                return;
            }
            if (!client.m_150110_().f_35937_) {
                client.m_6749_(-cost);
            }
            if ((stackCompound = input.m_41783_()) == null) {
                return;
            }
            books.m_41774_(1);
            if (books.m_41613_() <= 0) {
                this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
            }
            int repairCost = stackCompound.m_128451_("RepairCost");
            repairCost = (int)((double)repairCost - (double)repairCost * (1.0 / (double)list.size()));
            stackCompound.m_128405_("RepairCost", repairCost);
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(e, (int)lvl));
            this.itemHandler.setStackInSlot(2, book);
            list.remove(i);
            if (list.size() <= 0) {
                stackCompound.m_128473_("ench");
            }
            return;
        }
    }

    public int getCostInLevels(Enchantment e, int level) {
        int max = e.m_6586_();
        return (int)((double)(20 - (max == 1 ? 0 : (max == 2 ? 7 : 10))) * ((double)(e.m_44699_().ordinal() + 1) * 0.35) * DEOldConfig.disenchnaterCostMultiplyer) * level;
    }

    @Nullable
    public Enchantment getEnchantmentFromTag(CompoundTag c) {
        if (c != null && c.m_128461_("id") != null) {
            return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(c.m_128461_("id")));
        }
        return null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new DisenchanterMenu(currentWindowIndex, player.m_150109_(), this);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }
}

