/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.model;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.VBORenderType;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.model.ExtendedModelPart;
import com.brandon3055.brandonscore.client.render.EquippedItemModel;
import com.brandon3055.brandonscore.client.shader.BCShader;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.client.shader.ChaosEntityShader;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.client.shader.ShieldShader;
import com.brandon3055.draconicevolution.client.shader.ToolShader;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class ModularChestpieceModel<T extends LivingEntity>
extends HumanoidModel<T>
implements EquippedItemModel {
    private final TechLevel techLevel;
    private int shieldColour;
    private float shieldState;

    public ModularChestpieceModel(TechLevel techLevel, boolean isOnArmor) {
        super(ModularChestpieceModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f).m_171576_().m_171583_(64, 64));
        this.techLevel = techLevel;
        Map model = new OBJParser(new ResourceLocation("draconicevolution", "models/item/equipment/chestpeice.obj")).ignoreMtl().parse();
        CCModel baseModel = ((CCModel)model.get("base_model")).backfacedCopy();
        CCModel materialModel = ((CCModel)model.get("chevrons")).backfacedCopy();
        CCModel gemModel = ((CCModel)model.get("power_crystals")).backfacedCopy();
        CCModel coreGemModel = ((CCModel)model.get("crystal_core")).backfacedCopy();
        CCModel shieldHeadModel = ((CCModel)model.get("shield_head")).backfacedCopy();
        CCModel shieldBodyModel = ((CCModel)model.get("shield_body")).backfacedCopy();
        CCModel shieldRightArmModel = ((CCModel)model.get("shield_right_arm")).backfacedCopy();
        CCModel shieldLeftArmModel = ((CCModel)model.get("shield_left_arm")).backfacedCopy();
        CCModel shieldRightLegModel = ((CCModel)model.get("shield_right_leg")).backfacedCopy();
        CCModel shieldLeftLegModel = ((CCModel)model.get("shield_left_leg")).backfacedCopy();
        if (isOnArmor) {
            materialModel.apply((Transformation)new Translation(0.0, 0.0, -0.0625));
            gemModel.apply((Transformation)new Translation(0.0, 0.0, -0.03125));
            coreGemModel.apply((Transformation)new Translation(0.0, 0.0, -0.03125));
        }
        String levelName = techLevel.name().toLowerCase(Locale.ROOT);
        RenderType.CompositeRenderType baseType = RenderType.m_173215_((String)"draconicevolution:base", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.TOOL_BASE_SHADER).getShaderInstance())).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/item/equipment/" + levelName + "_chestpeice.png"), false, false)).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(true));
        RenderType.CompositeRenderType chaoticType = RenderType.m_173209_((String)"draconicevolution:tool_chaos", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> ((ChaosEntityShader)BCShaders.CHAOS_ENTITY_SHADER).getShaderInstance())).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/item/equipment/chaos_shader.png"), true, false)).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
        RenderType.CompositeRenderType gemType = RenderType.m_173209_((String)"draconicevolution:tool_gem", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.TOOL_GEM_SHADER).getShaderInstance())).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/item/equipment/shader_fallback_" + levelName + ".png"), false, false)).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
        RenderType.CompositeRenderType coreGemType = RenderType.m_173209_((String)"draconicevolution:core_gem", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.CHESTPIECE_GEM_SHADER).getShaderInstance())).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/item/equipment/shader_fallback_" + levelName + ".png"), false, false)).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
        RenderType.CompositeRenderType shieldType = RenderType.m_173209_((String)"draconicevolution:armor_shield", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> ((ShieldShader)DEShaders.CHESTPIECE_SHIELD_SHADER).getShaderInstance())).m_110685_(RenderStateShard.f_110139_).m_110675_(RenderStateShard.f_110129_).m_110687_(RenderStateShard.f_110114_).m_110671_(RenderStateShard.f_110152_).m_110691_(false));
        ExtendedModelPart body = new ExtendedModelPart();
        if (!isOnArmor) {
            body.addChild((ExtendedModelPart)new ChestpieceModelPart(baseModel, (RenderType)baseType, DEShaders.TOOL_BASE_SHADER));
        }
        if (techLevel == TechLevel.CHAOTIC) {
            body.addChild((ExtendedModelPart)new ChestpieceModelPart(materialModel, (RenderType)chaoticType, (BCShader<?>)BCShaders.CHAOS_ENTITY_SHADER));
        } else {
            body.addChild((ExtendedModelPart)new ChestpieceModelPart(materialModel, (RenderType)baseType, DEShaders.TOOL_BASE_SHADER));
        }
        body.addChild((ExtendedModelPart)new ChestpieceModelPart(gemModel, (RenderType)gemType, DEShaders.TOOL_GEM_SHADER));
        body.addChild((ExtendedModelPart)new CoreGemModelPart(coreGemModel, (RenderType)coreGemType, DEShaders.CHESTPIECE_GEM_SHADER));
        this.f_102810_ = body;
        this.f_102808_ = new ShieldModelPart(shieldHeadModel, (RenderType)shieldType, DEShaders.CHESTPIECE_SHIELD_SHADER);
        body.addChild((ExtendedModelPart)new ShieldModelPart(shieldBodyModel, (RenderType)shieldType, DEShaders.CHESTPIECE_SHIELD_SHADER));
        this.f_102812_ = new ShieldModelPart(shieldLeftArmModel, (RenderType)shieldType, DEShaders.CHESTPIECE_SHIELD_SHADER);
        this.f_102811_ = new ShieldModelPart(shieldRightArmModel, (RenderType)shieldType, DEShaders.CHESTPIECE_SHIELD_SHADER);
        this.f_102814_ = new ShieldModelPart(shieldLeftLegModel, (RenderType)shieldType, DEShaders.CHESTPIECE_SHIELD_SHADER);
        this.f_102813_ = new ShieldModelPart(shieldRightLegModel, (RenderType)shieldType, DEShaders.CHESTPIECE_SHIELD_SHADER);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102812_, (Object)this.f_102811_, (Object)this.f_102814_, (Object)this.f_102813_);
    }

    public void render(LivingEntity entity, PoseStack poseStack, MultiBufferSource buffers, ItemStack stack, int packedLight, int packedOverlay, float partialTicks) {
        ModuleHost host;
        ShieldControlEntity shieldControl;
        this.shieldColour = -1;
        this.shieldState = 0.0f;
        LazyOptional optionalHost = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (!stack.m_41619_() && optionalHost.isPresent() && (shieldControl = (ShieldControlEntity)(host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new)).getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null)) != null) {
            Player player;
            ContributorProperties props;
            this.shieldState = shieldControl.getShieldState();
            this.shieldColour = shieldControl.getShieldColour() | 0xFF000000;
            if (entity instanceof Player && (props = ContributorHandler.getProps((Player)(player = (Player)entity))).hasShieldRGB() && props.getConfig().overrideShield()) {
                this.shieldColour = props.getConfig().getShieldColour(partialTicks);
            }
        }
        if (this.f_102610_) {
            poseStack.m_85836_();
            if (this.f_102007_) {
                float f = 1.5f / this.f_102010_;
                poseStack.m_85841_(f, f, f);
            }
            poseStack.m_85837_(0.0, (double)(this.f_170338_ / 16.0f), (double)(this.f_170339_ / 16.0f));
            this.m_5607_().forEach(part -> ((ExtendedModelPart)part).render(poseStack, buffers, packedLight, packedOverlay));
            poseStack.m_85849_();
            poseStack.m_85836_();
            float f1 = 1.0f / this.f_102011_;
            poseStack.m_85841_(f1, f1, f1);
            poseStack.m_85837_(0.0, (double)(this.f_102012_ / 16.0f), 0.0);
            this.m_5608_().forEach(part -> ((ExtendedModelPart)part).render(poseStack, buffers, packedLight, packedOverlay));
            poseStack.m_85849_();
        } else {
            this.m_5607_().forEach(part -> ((ExtendedModelPart)part).render(poseStack, buffers, packedLight, packedOverlay));
            this.m_5608_().forEach(part -> ((ExtendedModelPart)part).render(poseStack, buffers, packedLight, packedOverlay));
        }
    }

    public class ChestpieceModelPart
    extends ExtendedModelPart {
        protected final VBORenderType renderType;
        protected final BCShader<?> shader;

        public ChestpieceModelPart(CCModel model, RenderType baseType, BCShader<?> shader) {
            this.shader = shader;
            this.renderType = new VBORenderType(baseType, (format, builder) -> {
                CCRenderState ccrs = CCRenderState.instance();
                ccrs.reset();
                ccrs.bind((VertexConsumer)builder, format);
                model.render(ccrs, new IVertexOperation[0]);
            });
        }

        public void render(PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float r, float g, float b, float a) {
            if (this.f_104207_) {
                poseStack.m_85836_();
                this.m_104299_(poseStack);
                Matrix4 mat = new Matrix4(poseStack);
                buffers.m_6299_((RenderType)this.renderType.withCallback(() -> {
                    ToolRenderBase.glUniformBaseColor(this.shader, ModularChestpieceModel.this.techLevel, 1.0f);
                    this.shader.getModelMatUniform().glUniformMatrix4f(mat);
                }));
                poseStack.m_85849_();
            }
        }
    }

    public class CoreGemModelPart
    extends ChestpieceModelPart {
        private final ToolShader shader;

        public CoreGemModelPart(CCModel model, RenderType baseType, ToolShader shader) {
            super(model, baseType, shader);
            this.shader = shader;
        }

        @Override
        public void render(PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float r, float g, float b, float a) {
            if (this.f_104207_) {
                poseStack.m_85836_();
                this.m_104299_(poseStack);
                Matrix4 mat = new Matrix4(poseStack);
                int color = ModularChestpieceModel.this.shieldColour;
                buffers.m_6299_((RenderType)this.renderType.withCallback(() -> {
                    this.shader.getBaseColorUniform().glUniform4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
                    this.shader.getModelMatUniform().glUniformMatrix4f(mat);
                }));
                poseStack.m_85849_();
            }
        }
    }

    public class ShieldModelPart
    extends ChestpieceModelPart {
        private final ShieldShader shader;

        public ShieldModelPart(CCModel model, RenderType baseType, ShieldShader shader) {
            super(model, baseType, shader);
            this.shader = shader;
        }

        @Override
        public void render(PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float r, float g, float b, float a) {
            if (ModularChestpieceModel.this.shieldState > 0.0f) {
                poseStack.m_85836_();
                this.m_104299_(poseStack);
                Matrix4 mat = new Matrix4(poseStack);
                int color = ModularChestpieceModel.this.shieldColour;
                float state = ModularChestpieceModel.this.shieldState;
                buffers.m_6299_((RenderType)this.renderType.withCallback(() -> {
                    this.shader.getBaseColourUniform().glUniform4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
                    this.shader.getActivationUniform().glUniform1f(state);
                    this.shader.getModelMatUniform().glUniformMatrix4f(mat);
                }));
                poseStack.m_85849_();
            }
        }
    }
}

