/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.colour.Colour;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RenderTileEnergyCrystal
implements BlockEntityRenderer<TileCrystalBase> {
    public static float[][] COLOURS = new float[][]{{0.0f, 0.2f, 0.3f}, {0.47f, 0.0f, 0.58f}, {1.0f, 0.4f, 0.1f}};
    private static final RenderType fallBackType = RenderType.m_110473_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/models/crystal_no_shader.png"));
    private static final RenderType fallBackOverlayType = RenderType.m_110473_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/models/crystal_base.png"));
    private static final RenderType crystalBaseType = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/models/crystal_base.png"));
    public static RenderType crystalType = RenderType.m_173209_((String)"crystal_type", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> DEShaders.energyCrystalShader)).m_110685_(RenderStateShard.f_110139_).m_110691_(false));
    private final CCModel crystalFull;
    private final CCModel crystalHalf;
    private final CCModel crystalBase;
    private static float[] r = new float[]{0.0f, 0.55f, 1.0f};
    private static float[] g = new float[]{0.35f, 0.3f, 0.572f};
    private static float[] b = new float[]{0.65f, 0.9f, 0.172f};

    public RenderTileEnergyCrystal(BlockEntityRendererProvider.Context context) {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/crystal.obj")).quads().ignoreMtl().parse();
        this.crystalFull = CCModel.combine(map.values());
        map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/crystal_half.obj")).quads().ignoreMtl().parse();
        this.crystalHalf = (CCModel)map.get("Crystal");
        this.crystalBase = (CCModel)map.get("Base");
    }

    public void render(TileCrystalBase te, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        int tier = te.getTier();
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = 240;
        ccrs.overlay = packedOverlay;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos pos = te.m_58899_();
        double x = player.m_20185_() - ((double)pos.m_123341_() + 0.5);
        double y = player.m_20186_() - ((double)pos.m_123342_() + 0.5);
        double z = player.m_20189_() - ((double)pos.m_123343_() + 0.5);
        double mm = MathHelper.clip((double)((x * x + y * y + z * z - 5.0) / 4096.0), (double)0.0, (double)1.0);
        ccrs.baseColour = -1;
        DEShaders.energyCrystalMipmap.glUniform1f((float)mm);
        DEShaders.energyCrystalColour.glUniform3f(COLOURS[tier][0], COLOURS[tier][1], COLOURS[tier][2]);
        if (te instanceof TileCrystalDirectIO) {
            ccrs.bind(crystalBaseType, getter);
            mat.translate(0.5, 1.0, 0.5);
            mat.scale(-0.5);
            mat.apply(Rotation.sideOrientation((int)((Direction)((TileCrystalDirectIO)te).facing.get()).m_122424_().m_122411_(), (int)0).at(new Vector3(0.0, 1.0, 0.0)));
            this.crystalBase.render(ccrs, new IVertexOperation[]{mat});
            mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), new Vector3(0.0, 1.0, 0.0));
            if (mm < 1.0) {
                ccrs.bind(crystalType, getter);
                this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            } else {
                ccrs.baseColour = Colour.packRGBA((double)r[tier], (double)g[tier], (double)b[tier], (double)1.0);
                ccrs.bind(fallBackType, getter);
                this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
                ccrs.baseColour = -1;
            }
        } else {
            mat.translate(Vector3.CENTER);
            mat.rotate(3.1415926535897403, new Vector3(1.0, 0.0, 0.0));
            mat.scale(-0.5);
            mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), new Vector3(0.0, 1.0, 0.0));
            if (mm < 1.0) {
                ccrs.bind(crystalType, getter);
                this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            } else {
                ccrs.baseColour = Colour.packRGBA((double)r[tier], (double)g[tier], (double)b[tier], (double)1.0);
                ccrs.bind(fallBackType, getter);
                this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
                ccrs.baseColour = -1;
            }
        }
        RenderUtils.endBatch((MultiBufferSource)getter);
    }
}

