/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.client.render.BlockEntityRendererTransparent;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public class RenderTileReactorCore
implements BlockEntityRendererTransparent<TileReactorCore> {
    private static CCModel model = null;
    public static RenderType REACTOR_CORE_TYPE = RenderType.m_173209_((String)"reactor_type", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> DEShaders.reactorShader)).m_110691_(false));
    public static RenderType REACTOR_SHIELD_TYPE = RenderType.m_173209_((String)"shield_type", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_173292_(new RenderStateShard.ShaderStateShard(() -> DEShaders.reactorShieldShader)).m_110691_(false));
    public static RenderType REACTOR_BEAM_TYPE = RenderType.m_173215_((String)"draconicevolutionbeam_typess", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_173292_(new RenderStateShard.ShaderStateShard(() -> DEShaders.reactorBeamShader)).m_110661_(RenderStateShard.f_110110_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));

    public RenderTileReactorCore(BlockEntityRendererProvider.Context context) {
        if (model == null) {
            Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/reactor/reactor_core.obj")).quads().ignoreMtl().parse();
            model = CCModel.combine(map.values());
        }
    }

    public void render(TileReactorCore te, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        double diameter = te.getCoreDiameter();
        float t = (float)(te.temperature.get() / 10000.0);
        float intensity = (double)t <= 0.2 ? (float)MathUtils.map((double)t, (double)0.0, (double)0.2, (double)0.0, (double)0.3) : ((double)t <= 0.8 ? (float)MathUtils.map((double)t, (double)0.2, (double)0.8, (double)0.3, (double)1.0) : (float)MathUtils.map((double)t, (double)0.8, (double)1.0, (double)1.0, (double)1.3));
        float shieldPower = (float)(te.maxShieldCharge.get() > 0.0 ? te.shieldCharge.get() / te.maxShieldCharge.get() : 0.0);
        float animation = (te.coreAnimation + partialTicks * (float)te.shaderAnimationState.get()) / 20.0f;
        mat.translate(0.5, 0.5, 0.5);
        mat.scale(diameter);
        mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), Vector3.Y_POS);
    }

    public static void renderCore(Matrix4 mat, CCRenderState ccrs, float animation, double animState, float intensity, float shieldPower, float partialTicks, MultiBufferSource getter) {
        DEShaders.reactorTime.glUniform1f(animation);
        DEShaders.reactorIntensity.glUniform1f(intensity);
        ccrs.bind(REACTOR_CORE_TYPE, getter);
        model.render(ccrs, new IVertexOperation[]{mat});
        RenderUtils.endBatch((MultiBufferSource)getter);
        mat.scale(1.05);
        DEShaders.reactorShieldTime.glUniform1f(animation);
        DEShaders.reactorShieldIntensity.glUniform1f(0.7f * shieldPower - (float)(1.0 - animState));
        ccrs.bind(REACTOR_SHIELD_TYPE, getter);
        model.render(ccrs, new IVertexOperation[]{mat});
        RenderUtils.endBatch((MultiBufferSource)getter);
    }

    public static void renderGUI(GuiRender render, TileReactorCore te) {
        double diameter = 100.0;
        float t = (float)(te.temperature.get() / 10000.0);
        float intensity = (double)t <= 0.2 ? (float)MathUtils.map((double)t, (double)0.0, (double)0.2, (double)0.0, (double)0.3) : ((double)t <= 0.8 ? (float)MathUtils.map((double)t, (double)0.2, (double)0.8, (double)0.3, (double)1.0) : (float)MathUtils.map((double)t, (double)0.8, (double)1.0, (double)1.0, (double)1.3));
        float animation = (te.coreAnimation + 0.0f * (float)te.shaderAnimationState.get()) / 20.0f;
        float shieldPower = (float)(te.maxShieldCharge.get() > 0.0 ? te.shieldCharge.get() / te.maxShieldCharge.get() : 0.0);
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource getter = RenderUtils.getBuffers();
        Matrix4 mat = new Matrix4(render.pose());
        mat.scale(diameter);
        mat.rotate((double)(((float)TimeKeeper.getClientTick() + mc.m_91296_()) / 400.0f), Vector3.Y_POS);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        RenderSystem.depthMask((boolean)false);
        RenderTileReactorCore.renderCore(mat, ccrs, animation, te.shaderAnimationState.get(), intensity, shieldPower, mc.m_91296_(), (MultiBufferSource)getter);
        RenderSystem.depthMask((boolean)true);
    }

    public void renderTransparent(TileReactorCore te, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        Matrix4 mat = new Matrix4(poseStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        double diameter = te.getCoreDiameter();
        float t = (float)(te.temperature.get() / 10000.0);
        float intensity = (double)t <= 0.2 ? (float)MathUtils.map((double)t, (double)0.0, (double)0.2, (double)0.0, (double)0.3) : ((double)t <= 0.8 ? (float)MathUtils.map((double)t, (double)0.2, (double)0.8, (double)0.3, (double)1.0) : (float)MathUtils.map((double)t, (double)0.8, (double)1.0, (double)1.0, (double)1.3));
        float shieldPower = (float)(te.maxShieldCharge.get() > 0.0 ? te.shieldCharge.get() / te.maxShieldCharge.get() : 0.0);
        float animation = (te.coreAnimation + partialTicks * (float)te.shaderAnimationState.get()) / 20.0f;
        mat.translate(0.5, 0.5, 0.5);
        mat.scale(diameter);
        mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), Vector3.Y_POS);
        RenderTileReactorCore.renderCore(mat, ccrs, animation, te.shaderAnimationState.get(), intensity, shieldPower, partialTicks, buffers);
        float coreSize = (float)te.getCoreDiameter() / 2.3f;
        float fxState = te.shieldAnimationState;
        for (Direction direction : Direction.values()) {
            TileReactorComponent component = te.getComponent(direction.m_122424_());
            if (component == null) continue;
            Direction facing = (Direction)component.facing.get();
            float dist = (float)Math.sqrt(component.m_58899_().m_123331_((Vec3i)te.m_58899_()));
            Vec3D pos1 = Vec3D.getCenter((BlockPos)component.m_58899_()).subtract(new Vec3D(te.m_58899_())).offset(facing, -0.35);
            if (component instanceof TileReactorInjector) {
                pos2 = pos1.copy().offset(facing, 0.6);
                DEShaders.reactorBeamType.glUniformI(new int[]{2});
                DEShaders.reactorBeamFade.glUniform1f(1.0f);
                DEShaders.reactorBeamPower.glUniform1f(fxState);
                DEShaders.reactorBeamStartup.glUniform1f(fxState);
                this.renderShaderBeam(ccrs, facing, fxState, buffers, poseStack, pos1, 0.1f, 0.1f, 0.6f, true, false);
                DEShaders.reactorBeamFade.glUniform1f(0.0f);
                this.renderShaderBeam(ccrs, facing, fxState, buffers, poseStack, pos2, 0.1f, (double)coreSize / 1.5, dist - coreSize * 1.3f, false, false);
            } else {
                pos2 = pos1.copy().offset(facing, 0.8);
                DEShaders.reactorBeamType.glUniformI(new int[]{1});
                DEShaders.reactorBeamFade.glUniform1f(1.0f);
                DEShaders.reactorBeamPower.glUniform1f((float)te.animExtractState.get());
                DEShaders.reactorBeamStartup.glUniform1f((float)te.animExtractState.get());
                this.renderShaderBeam(ccrs, facing, fxState, buffers, poseStack, pos1, 0.263f, 0.263f, 0.8f, true, false);
                DEShaders.reactorBeamFade.glUniform1f(0.0f);
                this.renderShaderBeam(ccrs, facing, fxState, buffers, poseStack, pos2, 0.263f, coreSize / 2.0f, dist - coreSize * 1.3f, false, false);
                DEShaders.reactorBeamType.glUniformI(new int[]{0});
                DEShaders.reactorBeamFade.glUniform1f(1.0f);
                DEShaders.reactorBeamPower.glUniform1f(fxState);
                DEShaders.reactorBeamStartup.glUniform1f(fxState);
                this.renderShaderBeam(ccrs, facing, fxState, buffers, poseStack, pos1, 0.355f, 0.355f, 0.8f, true, false);
                DEShaders.reactorBeamFade.glUniform1f(0.0f);
                this.renderShaderBeam(ccrs, facing, fxState, buffers, poseStack, pos2, 0.355f, coreSize, dist - coreSize, false, true);
            }
            ccrs.reset();
        }
    }

    public void renderShaderBeam(CCRenderState ccrs, Direction facing, float fxState, MultiBufferSource buffers, PoseStack poseStack, Vec3D pos, double widthStart, double widthEnd, float length, boolean fadeReverse, boolean highRes) {
        TransformingVertexConsumer buffer = new TransformingVertexConsumer(buffers.m_6299_(REACTOR_BEAM_TYPE), poseStack);
        ccrs.bind((VertexConsumer)buffer, DefaultVertexFormat.f_85818_);
        ccrs.startDrawing(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85818_);
        float sides = highRes ? 599.0f : 99.0f;
        int i = 0;
        while ((float)i < sides + 1.0f) {
            double angle = (double)((float)i / sides) * (Math.PI * 2);
            float sin = (float)MathHelper.sin((double)angle);
            float cos = (float)MathHelper.cos((double)angle);
            float texX = (float)i / sides;
            Vec3D point = pos.copy().radialOffset(facing.m_122434_(), (double)sin, (double)cos, widthStart);
            buffer.m_5483_(point.x, point.y, point.z).m_85950_(1.0f, 1.0f, 1.0f, fadeReverse ? 0.0f : fxState).m_7421_(texX, fadeReverse ? 0.1f : 1.0f).m_5752_();
            point.offset(facing, (double)length);
            point.radialOffset(facing.m_122434_(), (double)sin, (double)cos, widthEnd - widthStart);
            buffer.m_5483_(point.x, point.y, point.z).m_85950_(1.0f, 1.0f, 1.0f, fadeReverse ? fxState : 0.0f).m_7421_(texX, 0.0f).m_5752_();
            ++i;
        }
        ccrs.draw();
        RenderUtils.endBatch((MultiBufferSource)buffers);
    }

    public boolean shouldRenderOffScreen(TileReactorCore te) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }
}

