/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.api.energy.ICrystalBinder;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.handlers.BinderHandler;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.ArrayList;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DEEventHandler {
    private static WeakHashMap<Mob, Long> deSpawnedMobs = new WeakHashMap();
    private static Random random = new Random();
    public static int serverTicks = 0;

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CrystalUpdateBatcher.tickEnd();
            ++serverTicks;
            if (!deSpawnedMobs.isEmpty()) {
                ArrayList toRemove = new ArrayList();
                long time = System.currentTimeMillis();
                deSpawnedMobs.forEach((entity, aLong) -> {
                    if (time - aLong > 30000L) {
                        entity.f_21353_ = false;
                        toRemove.add(entity);
                    }
                });
                toRemove.forEach(entity -> deSpawnedMobs.remove(entity));
            }
        }
    }

    public static void onMobSpawnedBySpawner(Mob entity) {
        deSpawnedMobs.put(entity, System.currentTimeMillis());
    }

    @SubscribeEvent
    public void itemToss(ItemTossEvent event) {
        ItemEntity item = event.getEntity();
        Player player = event.getPlayer();
        if (DEOldConfig.forceDroppedItemOwner && player != null && item.m_19749_() == null) {
            item.m_32052_(player.m_20148_());
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        ItemStack other = player.m_21120_(event.getHand() == InteractionHand.OFF_HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        if (stack.m_41720_() instanceof ICrystalBinder && other.m_41720_() instanceof ICrystalBinder) {
            if (event.getHand() == InteractionHand.OFF_HAND) {
                event.setCanceled(true);
                return;
            }
        } else {
            if (event.getHand() == InteractionHand.OFF_HAND && other.m_41720_() instanceof ICrystalBinder) {
                event.setCanceled(true);
                return;
            }
            if (event.getHand() == InteractionHand.MAIN_HAND && other.m_41720_() instanceof ICrystalBinder) {
                event.setCanceled(true);
                return;
            }
        }
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ICrystalBinder)) {
            return;
        }
        if (BinderHandler.onBinderUse(event.getEntity(), event.getHand(), event.getLevel(), event.getPos(), stack, event.getFace())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getLevel().f_46443_ || event.isCanceled() || !event.getEntity().m_6144_() || !(event.getItemStack().m_41720_() instanceof ICrystalBinder)) {
            return;
        }
        BlockHitResult traceResult = RayTracer.retrace((Player)event.getEntity());
        if (traceResult.m_6662_() == HitResult.Type.BLOCK) {
            return;
        }
        if (BinderHandler.clearBinder(event.getEntity(), event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof GuardianCrystalEntity) {
            event.setCanceled(true);
        }
    }
}

