/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorSaveData;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.GroundTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoundDislocator
extends Dislocator {
    public BoundDislocator(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world instanceof ServerLevel && TimeKeeper.getServerTick() % 20 == 0 && BoundDislocator.isValid(stack) && !BoundDislocator.isPlayer(stack) && entity instanceof Player) {
            DislocatorSaveData.updateLinkTarget(world, stack, new PlayerTarget((Player)entity));
        }
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        if (entity.m_9236_() instanceof ServerLevel && TimeKeeper.getServerTick() % 20 == 0 && BoundDislocator.isValid(stack) && !BoundDislocator.isPlayer(stack)) {
            DislocatorSaveData.updateLinkTarget(entity.m_9236_(), stack, new GroundTarget(entity));
        }
        return false;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.m_9236_().f_46443_) {
            return true;
        }
        TargetPos location = this.getTargetPos(stack, player.m_9236_());
        if (location == null) {
            if (BoundDislocator.isPlayer(stack)) {
                player.m_213846_((Component)Component.m_237115_((String)"dislocate.draconicevolution.bound.cant_find_player").m_130940_(ChatFormatting.RED));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"dislocate.draconicevolution.bound.cant_find_target").m_130940_(ChatFormatting.RED));
            }
            return true;
        }
        if (!entity.m_6072_() || !(entity instanceof LivingEntity)) {
            return true;
        }
        BCoreNetwork.sendSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f), (boolean)false);
        location.setPitch(player.m_146909_());
        location.setYaw(player.m_146908_());
        BoundDislocator.notifyArriving(stack, player.m_9236_(), entity);
        location.teleport(entity);
        BCoreNetwork.sendSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f), (boolean)false);
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_9236_().f_46443_) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (stack.m_41720_() == DEContent.DISLOCATOR_P2P_UNBOUND.get()) {
            UUID linkID = UUID.randomUUID();
            ItemStack boundA = BoundDislocator.createP2PDislocator(linkID);
            ItemStack boundB = BoundDislocator.createP2PDislocator(linkID);
            player.m_21008_(hand, ItemStack.f_41583_);
            InventoryUtils.givePlayerStack((Player)player, (ItemStack)boundA);
            InventoryUtils.givePlayerStack((Player)player, (ItemStack)boundB);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (stack.m_41720_() == DEContent.DISLOCATOR_PLAYER_UNBOUND.get()) {
            ItemStack bound = new ItemStack((ItemLike)DEContent.DISLOCATOR_PLAYER.get());
            BoundDislocator.setPlayerID(bound, player.m_20148_());
            BoundDislocator.setDislocatorId(stack, UUID.randomUUID());
            ItemNBTHelper.setString((ItemStack)bound, (String)"player_name", (String)player.m_7755_().getString());
            player.m_21008_(hand, ItemStack.f_41583_);
            InventoryUtils.givePlayerStack((Player)player, (ItemStack)bound);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        TargetPos location = this.getTargetPos(stack, world);
        if (location == null) {
            if (BoundDislocator.isPlayer(stack)) {
                player.m_213846_((Component)Component.m_237115_((String)"dislocate.draconicevolution.bound.cant_find_player").m_130940_(ChatFormatting.RED));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"dislocate.draconicevolution.bound.cant_find_target").m_130940_(ChatFormatting.RED));
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BCoreNetwork.sendSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f), (boolean)false);
        location.setPitch(player.m_146909_());
        location.setYaw(player.m_146908_());
        BoundDislocator.notifyArriving(stack, player.m_9236_(), (Entity)player);
        location.teleport((Entity)player);
        BCoreNetwork.sendSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f), (boolean)false);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static boolean isPlayer(ItemStack stack) {
        return stack.m_41720_() == DEContent.DISLOCATOR_PLAYER.get();
    }

    public static boolean isP2P(ItemStack stack) {
        return stack.m_41720_() == DEContent.DISLOCATOR_P2P.get();
    }

    public static UUID getPlayerID(ItemStack stack) {
        return ItemNBTHelper.getUUID((ItemStack)stack, (String)"player_id", null);
    }

    public static void setPlayerID(ItemStack stack, UUID playerID) {
        stack.m_41784_().m_128362_("player_id", playerID);
    }

    public static boolean isValid(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (stack.m_41720_() instanceof BoundDislocator) {
            return compound != null && BoundDislocator.getLinkId(stack) != null && BoundDislocator.getDislocatorId(stack) != null;
        }
        return false;
    }

    @Nullable
    public static UUID getDislocatorId(ItemStack stack) {
        return ItemNBTHelper.getUUID((ItemStack)stack, (String)"stack_id", null);
    }

    @Nullable
    public static UUID getLinkId(ItemStack stack) {
        return ItemNBTHelper.getUUID((ItemStack)stack, (String)"link_id", null);
    }

    private static void setDislocatorId(ItemStack stack, UUID dislocatorID) {
        ItemNBTHelper.setUUID((ItemStack)stack, (String)"stack_id", (UUID)dislocatorID);
    }

    private static void setLinkId(ItemStack stack, UUID linkID) {
        ItemNBTHelper.setUUID((ItemStack)stack, (String)"link_id", (UUID)linkID);
    }

    private static ItemStack createP2PDislocator(UUID linkID) {
        ItemStack stack = new ItemStack((ItemLike)DEContent.DISLOCATOR_P2P.get());
        BoundDislocator.setLinkId(stack, linkID);
        BoundDislocator.setDislocatorId(stack, UUID.randomUUID());
        return stack;
    }

    @Override
    public TargetPos getTargetPos(ItemStack stack, @Nullable Level world) {
        if (world instanceof ServerLevel) {
            if (BoundDislocator.isPlayer(stack)) {
                ServerPlayer player;
                UUID playerID = BoundDislocator.getPlayerID(stack);
                MinecraftServer server = world.m_7654_();
                if (playerID != null && server != null && (player = server.m_6846_().m_11259_(playerID)) != null) {
                    return new TargetPos((Entity)player);
                }
            } else {
                DislocatorTarget target = DislocatorSaveData.getLinkTarget(world, stack);
                UUID linkID = BoundDislocator.getLinkId(stack);
                if (target != null && linkID != null) {
                    return target.getTargetPos(world.m_7654_(), linkID, BoundDislocator.getDislocatorId(stack));
                }
            }
        }
        return null;
    }

    public static void notifyArriving(ItemStack stack, Level world, Entity entity) {
        DislocatorTarget target;
        if (world instanceof ServerLevel && (target = DislocatorSaveData.getLinkTarget(world, stack)) != null) {
            target.preTeleport(world.m_7654_(), entity);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41720_() == DEContent.DISLOCATOR_P2P_UNBOUND.get()) {
            tooltip.add((Component)Component.m_237115_((String)"dislocate.draconicevolution.bound.click_to_link").m_130940_(ChatFormatting.GREEN));
        } else if (stack.m_41720_() == DEContent.DISLOCATOR_PLAYER_UNBOUND.get()) {
            tooltip.add((Component)Component.m_237115_((String)"dislocate.draconicevolution.bound.click_to_link_self").m_130940_(ChatFormatting.GREEN));
        } else if (BoundDislocator.isPlayer(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"dislocate.draconicevolution.bound.player_link").m_130946_(": ").m_130946_(ItemNBTHelper.getString((ItemStack)stack, (String)"player_name", (String)"Unknown Player")).m_130940_(ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"dislocate.draconicevolution.bound.link_id").m_130946_(": ").m_130946_(String.valueOf(BoundDislocator.getLinkId(stack))).m_130940_(ChatFormatting.BLUE));
        }
    }

    @Override
    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.RARE;
    }

    @Override
    public boolean m_41386_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268724_);
    }
}

