/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.gui.DislocatorGui;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class DislocatorAdvanced
extends Dislocator {
    public static final UUID MSG_ID1 = UUID.fromString("1a0f4ae8-7884-4402-b223-d93f221466e3");
    public static final UUID MSG_ID2 = UUID.fromString("bb5bf7be-5fbb-44b1-b7bc-35ac89b2890c");
    public static final UUID MSG_ID3 = UUID.fromString("d9349a0c-6013-43ea-9be2-04686eb8bd2d");

    public DislocatorAdvanced(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean m_41386_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268724_);
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.m_9236_().f_46443_) {
            return true;
        }
        DislocatorTarget location = this.getTargetPos(stack, player.m_9236_());
        int fuel = this.getFuel(stack);
        if (!player.m_150110_().f_35937_ && fuel <= 0) {
            this.messageUser((Entity)player, (Component)Component.m_237115_((String)"dislocate.draconicevolution.no_fuel").m_130940_(ChatFormatting.RED));
            return true;
        }
        if (entity instanceof Player) {
            if (entity.m_6144_()) {
                if (this.useFuel(stack, player)) {
                    this.dislocateEntity(stack, (Entity)player, entity, location);
                }
            } else {
                this.messageUser((Entity)player, (Component)Component.m_237115_((String)"dislocate.draconicevolution.player_allow"));
            }
            return true;
        }
        if (!entity.m_6072_() || !(entity instanceof LivingEntity)) {
            return true;
        }
        if (this.useFuel(stack, player)) {
            this.dislocateEntity(stack, (Entity)player, entity, location);
            this.messageUser((Entity)player, (Component)Component.m_237113_((String)(I18n.m_118938_((String)"dislocate.draconicevolution.entity_sent_to", (Object[])new Object[0]) + " " + location.getReadableName(false))).m_130940_(ChatFormatting.GREEN));
        }
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        DislocatorTarget location = this.getTargetPos(stack, player.m_9236_());
        boolean blink = this.getBlinkMode(stack);
        if (player.m_6144_() || location == null && !blink) {
            if (world.f_46443_) {
                this.openGui(stack, player);
            }
        } else if (!world.f_46443_) {
            if (blink) {
                this.handleBlink((ServerPlayer)player, stack, false);
            } else {
                this.handleTeleport(player, stack, location, false);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGui(ItemStack stack, Player player) {
        Minecraft.m_91087_().m_91152_((Screen)new DislocatorGui.Screen(stack.m_41786_(), player));
    }

    private void handleTeleport(Player player, ItemStack stack, TargetPos targetPos, boolean showFuel) {
        int fuel = this.getFuel(stack);
        if (!player.m_150110_().f_35937_ && fuel <= 0) {
            this.messageUser((Entity)player, (Component)Component.m_237115_((String)"dislocate.draconicevolution.no_fuel").m_130940_(ChatFormatting.RED));
        } else if (this.useFuel(stack, player)) {
            this.dislocateEntity(stack, (Entity)player, (Entity)player, targetPos);
            if (showFuel) {
                player.m_5661_((Component)Component.m_237115_((String)"dislocate.draconicevolution.teleport_fuel").m_130946_(" " + this.getFuel(stack)).m_130940_(ChatFormatting.WHITE), true);
            }
        }
    }

    private void handleBlink(ServerPlayer player, ItemStack stack, boolean showFuel) {
        if (!player.m_150110_().f_35937_) {
            if (player.m_36335_().m_41519_(stack.m_41720_())) {
                return;
            }
            int blinkFuel = stack.m_41784_().m_128445_("blink_fuel");
            if (blinkFuel <= 0) {
                if (!this.useFuel(stack, (Player)player)) {
                    this.messageUser((Entity)player, (Component)Component.m_237115_((String)"dislocate.draconicevolution.no_fuel").m_130940_(ChatFormatting.RED));
                    return;
                }
                blinkFuel = DEConfig.dislocatorBlinksPerPearl;
            }
            stack.m_41784_().m_128344_("blink_fuel", (byte)(--blinkFuel));
            if (showFuel) {
                player.m_5661_((Component)Component.m_237115_((String)"dislocate.draconicevolution.teleport_fuel").m_130946_(" " + this.getFuel(stack)).m_130940_(ChatFormatting.WHITE), true);
            }
            player.m_36335_().m_41524_(stack.m_41720_(), 5);
        }
        Vec3 playerVec = player.m_20299_(1.0f);
        double range = DEConfig.dislocatorBlinkRange;
        Vec3 endVec = playerVec.m_82549_(player.m_20154_().m_82542_(range, range, range));
        ClipContext context = new ClipContext(playerVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = player.m_9236_().m_45547_(context);
        player.m_9236_().m_6263_(null, playerVec.f_82479_, playerVec.f_82480_, playerVec.f_82481_, (SoundEvent)DESounds.BLINK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        DraconicNetwork.sendBlinkEffect(player, (float)(playerVec.m_82554_(endVec) / range));
        if (result.m_6662_() == HitResult.Type.MISS) {
            if (player.m_21255_()) {
                player.f_8906_.m_9780_(endVec.f_82479_, endVec.f_82480_, endVec.f_82481_, player.m_146908_(), player.m_146909_(), (Set)Sets.newHashSet((Object[])new RelativeMovement[]{RelativeMovement.X, RelativeMovement.Y, RelativeMovement.Z}));
                player.m_5616_(player.m_146908_());
            } else {
                TeleportUtils.teleportEntity((Entity)player, (ResourceKey)player.m_9236_().m_46472_(), (double)endVec.f_82479_, (double)endVec.f_82480_, (double)endVec.f_82481_);
            }
        } else {
            BlockPos pos = result.m_82425_().m_121945_(result.m_82434_());
            Vec3D vec = new Vec3D(pos).add(0.5, 0.0, 0.5);
            switch (result.m_82434_()) {
                case DOWN: 
                case UP: {
                    break;
                }
                default: {
                    if (!player.m_9236_().m_8055_(pos.m_7495_()).m_60647_((BlockGetter)player.m_9236_(), pos.m_7495_(), PathComputationType.AIR)) break;
                    vec.y -= 1.0;
                }
            }
            TeleportUtils.teleportEntity((Entity)player, (ResourceKey)player.m_9236_().m_46472_(), (double)vec.x, (double)vec.y, (double)vec.z);
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)DESounds.BLINK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public DislocatorTarget getTargetPos(ItemStack stack, @Nullable Level world) {
        return (DislocatorTarget)((Object)DataUtils.safeGet(this.getTargetList(stack), (int)this.getSelectedIndex(stack)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        DislocatorTarget selected = this.getTargetPos(stack, world);
        int fuel = this.getFuel(stack);
        if (selected != null) {
            tooltip.add((Component)Component.m_237113_((String)selected.getName()).m_130940_(ChatFormatting.GOLD));
        }
        tooltip.add((Component)Component.m_237115_((String)"dislocate.draconicevolution.fuel").m_130946_(" " + fuel).m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)Component.m_237115_((String)"dislocate.draconicevolution.to_open_gui").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
    }

    @Override
    public void generateHudText(ItemStack stack, Player player, List<Component> displayList) {
        DislocatorTarget location = this.getTargetPos(stack, player.m_9236_());
        if (location != null) {
            displayList.add((Component)Component.m_237113_((String)location.getName()));
        }
        displayList.add((Component)Component.m_237115_((String)"dislocate.draconicevolution.fuel").m_130946_(" " + this.getFuel(stack)));
    }

    @Override
    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int getFuel(ItemStack stack) {
        return stack.m_41784_().m_128451_("fuel");
    }

    public void setFuel(ItemStack stack, int value) {
        stack.m_41784_().m_128405_("fuel", value);
    }

    public boolean useFuel(ItemStack stack, Player player) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        int fuel = this.getFuel(stack);
        if (fuel > 0) {
            this.setFuel(stack, fuel - 1);
            return true;
        }
        return false;
    }

    public List<DislocatorTarget> getTargetList(ItemStack stack) {
        ListTag targets = stack.m_41784_().m_128437_("locations", 10);
        ArrayList<DislocatorTarget> list = new ArrayList<DislocatorTarget>();
        targets.forEach(inbt -> list.add(new DislocatorTarget((CompoundTag)inbt)));
        return list;
    }

    public void setTargetList(ItemStack stack, List<DislocatorTarget> targets) {
        ListTag list = new ListTag();
        targets.forEach(e -> list.add((Object)e.writeToNBT()));
        stack.m_41784_().m_128365_("locations", (Tag)list);
    }

    public int getSelectedIndex(ItemStack stack) {
        return stack.m_41784_().m_128451_("selected");
    }

    public void setSelectedIndex(ItemStack stack, int index) {
        stack.m_41784_().m_128405_("selected", index);
    }

    public boolean getBlinkMode(ItemStack stack) {
        return stack.m_41784_().m_128471_("blink");
    }

    public void setBlinkMode(ItemStack stack, boolean blink) {
        stack.m_41784_().m_128379_("blink", blink);
    }

    public void handleClientAction(ServerPlayer player, ItemStack stack, MCDataInput input) {
        byte action = input.readByte();
        int selectIndex = this.getSelectedIndex(stack);
        LinkedList<DislocatorTarget> list = new LinkedList<DislocatorTarget>(this.getTargetList(stack));
        DislocatorTarget selected = selectIndex >= 0 && selectIndex < list.size() ? list.get(selectIndex) : null;
        switch (action) {
            case 0: {
                byte mode = input.readByte();
                int index = input.readVarInt();
                DislocatorTarget newPoint = new DislocatorTarget((Entity)player).setName(input.readString());
                if (mode == 1 || index < 0) {
                    list.addFirst(newPoint);
                } else if (mode == 2 || index >= list.size()) {
                    list.addLast(newPoint);
                } else {
                    list.add(index, newPoint);
                }
                selected = newPoint;
                break;
            }
            case 1: {
                DataUtils.safeRemove(list, (int)input.readVarInt());
                break;
            }
            case 2: {
                DataUtils.ifPresent(list, (int)input.readVarInt(), e -> e.setName(input.readString()));
                break;
            }
            case 3: {
                DataUtils.ifPresent(list, (int)input.readVarInt(), e -> e.setLocked(input.readBoolean()));
                break;
            }
            case 4: {
                selected = (DislocatorTarget)((Object)DataUtils.safeGet(list, (int)input.readVarInt()));
                break;
            }
            case 5: {
                this.setBlinkMode(stack, input.readBoolean());
                break;
            }
            case 6: {
                this.addFuel(stack, (Player)player, input.readBoolean(), input.readBoolean());
                return;
            }
            case 7: {
                DataUtils.ifPresent(list, (int)input.readVarInt(), e -> e.update((Entity)player));
                break;
            }
            case 8: {
                DataUtils.ifPresent(list, (int)input.readVarInt(), e -> this.handleTeleport((Player)player, stack, (TargetPos)e, true));
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                if (list.size() == 0) {
                    return;
                }
                if (selected == null) {
                    return;
                }
                int newIndex = input.readVarInt();
                if (newIndex > selectIndex) {
                    --newIndex;
                }
                if (newIndex < 0 || newIndex >= list.size()) {
                    return;
                }
                list.remove((Object)selected);
                list.add(newIndex, selected);
                break;
            }
            case 11: {
                if (list.size() == 0) {
                    return;
                }
                this.handleTeleport((Player)player, stack, selected, true);
                break;
            }
            case 12: {
                this.handleBlink(player, stack, true);
                break;
            }
            case 13: {
                if (list.size() == 0) {
                    return;
                }
                selected = (DislocatorTarget)((Object)DataUtils.safeGet(list, (int)Math.floorMod(selectIndex += input.readBoolean() ? 1 : -1, list.size())));
                if (selected == null) break;
                DislocatorTarget up = (DislocatorTarget)((Object)DataUtils.safeGet(list, (int)Math.floorMod(selectIndex - 1, list.size())));
                DislocatorTarget down = (DislocatorTarget)((Object)DataUtils.safeGet(list, (int)Math.floorMod(selectIndex + 1, list.size())));
                if (up != null) {
                    ChatHelper.sendIndexed((Player)player, (Component)Component.m_237113_((String)up.getName()).m_130940_(ChatFormatting.GRAY), (UUID)MSG_ID1);
                }
                ChatHelper.sendIndexed((Player)player, (Component)Component.m_237113_((String)(ChatFormatting.GREEN + ">" + ChatFormatting.GOLD + selected.getName() + ChatFormatting.GREEN + "<")), (UUID)MSG_ID2);
                if (down == null) break;
                ChatHelper.sendIndexed((Player)player, (Component)Component.m_237113_((String)down.getName()).m_130940_(ChatFormatting.GRAY), (UUID)MSG_ID3);
                break;
            }
            default: {
                return;
            }
        }
        this.setTargetList(stack, list);
        if (selected != null) {
            if (list.contains((Object)selected)) {
                this.setSelectedIndex(stack, list.indexOf((Object)selected));
            } else if (selectIndex > 0 && selectIndex - 1 < list.size()) {
                this.setSelectedIndex(stack, selectIndex - 1);
            }
        } else {
            this.setSelectedIndex(stack, 0);
        }
    }

    public void addFuel(ItemStack dislocator, Player player, boolean fullStack, boolean allStacks) {
        int max = DEConfig.dislocatorMaxFuel - this.getFuel(dislocator);
        int wanted = allStacks ? max : Math.min(max, fullStack ? 16 : 1);
        int added = 0;
        for (int i = 0; i < player.m_150109_().m_6643_() && wanted > 0; ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!stack.m_204117_(Tags.Items.ENDER_PEARLS)) continue;
            while (!stack.m_41619_() && wanted > 0) {
                --wanted;
                stack.m_41774_(1);
                ++added;
            }
        }
        this.setFuel(dislocator, this.getFuel(dislocator) + added);
    }

    public static ItemStack findDislocator(Player player) {
        ItemStack stack = HandHelper.getItem((Player)player, (Item)((Item)DEContent.DISLOCATOR_ADVANCED.get()));
        if (!stack.m_41619_()) {
            return stack;
        }
        stack = EquipmentManager.findItem((Item)DEContent.DISLOCATOR_ADVANCED.get(), (LivingEntity)player);
        if (!stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < player.m_150109_().m_6643_() - player.m_150109_().f_35976_.size(); ++i) {
            stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != DEContent.DISLOCATOR_ADVANCED.get()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static class DislocatorTarget
    extends TargetPos {
        private String name;
        private boolean locked;

        public DislocatorTarget() {
        }

        public DislocatorTarget(Entity entity) {
            super(entity);
        }

        public DislocatorTarget(CompoundTag nbt) {
            super(nbt);
        }

        public DislocatorTarget(double x, double y, double z, ResourceKey<Level> dimension) {
            super(x, y, z, dimension);
        }

        public DislocatorTarget(double x, double y, double z, ResourceKey<Level> dimension, float pitch, float yaw) {
            super(x, y, z, dimension, pitch, yaw);
        }

        public DislocatorTarget setName(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name == null ? "" : this.name;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public CompoundTag writeToNBT(CompoundTag nbt) {
            nbt.m_128359_("name", this.name);
            nbt.m_128379_("lock", this.locked);
            return super.writeToNBT(nbt);
        }

        public void readFromNBT(CompoundTag nbt) {
            super.readFromNBT(nbt);
            this.name = nbt.m_128461_("name");
            this.locked = nbt.m_128471_("lock");
        }

        public void write(MCDataOutput output) {
            super.write(output);
            output.writeString(this.name);
            output.writeBoolean(this.locked);
        }

        public void read(MCDataInput input) {
            super.read(input);
            this.name = input.readString();
            this.locked = input.readBoolean();
        }
    }
}

