/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.mixin;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.world.ChaosIslandFeature;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DensityFunctions.EndIslandDensityFunction.class})
public class EndIslandDensityFunctionMixin {
    @Inject(method={"getHeightValue(Lnet/minecraft/world/level/levelgen/synth/SimplexNoise;II)F"}, cancellable=true, at={@At(value="RETURN")})
    private static void getHeightValue(SimplexNoise pNoise, int pX, int pZ, CallbackInfoReturnable<Float> cir) {
        if (!DEConfig.chaosIslandEnabled) {
            return;
        }
        int x = pX / 2;
        int z = pZ / 2;
        ChunkPos chunkPos = new ChunkPos(x, z);
        ChunkPos closestSpawn = ChaosIslandFeature.getClosestSpawn(chunkPos);
        if (closestSpawn.f_45578_ == 0 && closestSpawn.f_45579_ == 0) {
            return;
        }
        ChaosIslandFeature.overrideHeightValue(chunkPos, closestSpawn, ((Float)cir.getReturnValue()).floatValue(), arg_0 -> cir.setReturnValue(arg_0));
    }
}

