/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client;

import com.enderio.base.client.model.PaintedBlockGeometry;
import com.enderio.base.client.particle.RangeParticle;
import com.enderio.base.client.renderer.block.EnderSkullRenderer;
import com.enderio.base.client.renderer.glider.ActiveGliderRenderLayer;
import com.enderio.base.client.renderer.item.GlassIconDecorator;
import com.enderio.base.common.block.EnderSkullBlock;
import com.enderio.base.common.init.EIOBlockEntities;
import com.enderio.base.common.init.EIOBlocks;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.init.EIOParticles;
import com.enderio.core.client.item.FluidBarDecorator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    private static final Map<Item, ResourceLocation> HANG_GLIDER_MODEL_LOCATION = new HashMap<Item, ResourceLocation>();
    public static final Map<Item, BakedModel> GLIDER_MODELS = new HashMap<Item, BakedModel>();

    @SubscribeEvent
    public static void additionalModels(ModelEvent.RegisterAdditional event) {
        Set gliderModels = Minecraft.m_91087_().m_91098_().m_214159_("models/enderio_glider", rl -> rl.m_135815_().endsWith(".json")).keySet();
        for (ResourceLocation gliderModelPath : gliderModels) {
            Optional<Item> gliderItem = ClientSetup.findGliderForModelRL(gliderModelPath);
            if (!gliderItem.isPresent()) continue;
            ResourceLocation modelLookupLocation = new ResourceLocation(gliderModelPath.m_135827_(), gliderModelPath.m_135815_().substring("models/".length(), gliderModelPath.m_135815_().length() - 5));
            event.register(modelLookupLocation);
            HANG_GLIDER_MODEL_LOCATION.put(gliderItem.get(), modelLookupLocation);
        }
    }

    @SubscribeEvent
    public static void itemDecorators(RegisterItemDecorationsEvent event) {
        event.register((ItemLike)EIOItems.LEVITATION_STAFF.get(), (IItemDecorator)FluidBarDecorator.INSTANCE);
        EIOBlocks.GLASS_BLOCKS.values().forEach(blocks -> blocks.getAllBlocks().forEach(block -> event.register((ItemLike)block.get(), (IItemDecorator)GlassIconDecorator.INSTANCE)));
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        for (String skin : event.getSkins()) {
            LivingEntityRenderer livingEntityRenderer = event.getSkin(skin);
            if (!(livingEntityRenderer instanceof PlayerRenderer)) continue;
            PlayerRenderer playerRenderer = (PlayerRenderer)livingEntityRenderer;
            playerRenderer.m_115326_((RenderLayer)new ActiveGliderRenderLayer(playerRenderer));
        }
    }

    @SubscribeEvent
    public static void bakingCompleted(ModelEvent.BakingCompleted event) {
        GLIDER_MODELS.clear();
        HANG_GLIDER_MODEL_LOCATION.forEach((item, modelRL) -> {
            BakedModel bakedModel = (BakedModel)event.getModels().get(modelRL);
            if (bakedModel != null) {
                GLIDER_MODELS.put((Item)item, bakedModel);
            }
        });
        HANG_GLIDER_MODEL_LOCATION.clear();
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)EIOParticles.RANGE_PARTICLE.get(), RangeParticle.Provider::new);
    }

    private static Optional<Item> findGliderForModelRL(ResourceLocation rl) {
        String namespace = rl.m_135827_();
        String path = rl.m_135815_().substring("models/enderio_glider/".length(), rl.m_135815_().length() - 5);
        return Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, path)));
    }

    @SubscribeEvent
    public static void modelInit(ModelEvent.RegisterGeometryLoaders event) {
        event.register("painted_block", (IGeometryLoader)new PaintedBlockGeometry.Loader());
    }

    @SubscribeEvent
    public static void modelRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)EIOBlockEntities.ENDER_SKULL.get(), EnderSkullRenderer::new);
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(EnderSkullRenderer.ENDER_SKULL, EnderSkullRenderer.EnderSkullModel::createMobHeadLayer);
    }

    @SubscribeEvent
    public static void registerEnderSkulls(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel((SkullBlock.Type)EnderSkullBlock.EIOSkulls.ENDERMAN, (SkullModelBase)new EnderSkullRenderer.EnderSkullModel(event.getEntityModelSet().m_171103_(EnderSkullRenderer.ENDER_SKULL)));
        SkullBlockRenderer.f_112519_.put(EnderSkullBlock.EIOSkulls.ENDERMAN, new ResourceLocation("textures/entity/enderman/enderman.png"));
    }
}

