/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.block.glass;

import com.enderio.EnderIO;
import com.enderio.api.misc.IIcon;
import com.enderio.api.misc.Vector2i;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.lang.EIOLang;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import org.jetbrains.annotations.Nullable;

public enum GlassCollisionPredicate implements IIcon
{
    NONE(ctx -> false, null),
    PLAYERS_PASS(ctx -> ctx.m_193113_() instanceof Player, EIOLang.GLASS_COLLISION_PLAYERS_PASS),
    PLAYERS_BLOCK(ctx -> !(ctx.m_193113_() instanceof Player), EIOLang.GLASS_COLLISION_PLAYERS_BLOCK),
    MOBS_PASS(ctx -> ctx.m_193113_() instanceof Mob, EIOLang.GLASS_COLLISION_MOBS_PASS),
    MOBS_BLOCK(ctx -> !(ctx.m_193113_() instanceof Mob), EIOLang.GLASS_COLLISION_MOBS_BLOCK),
    ANIMALS_PASS(ctx -> ctx.m_193113_() instanceof Animal, EIOLang.GLASS_COLLISION_ANIMALS_PASS),
    ANIMALS_BLOCK(ctx -> !(ctx.m_193113_() instanceof Animal), EIOLang.GLASS_COLLISION_ANIMALS_BLOCK);

    private final Predicate<EntityCollisionContext> predicate;
    @Nullable
    private final Component description;
    public static final ResourceLocation TEXTURE;

    private GlassCollisionPredicate(Predicate<EntityCollisionContext> predicate, Component description) {
        this.predicate = predicate;
        this.description = description;
    }

    public boolean canPass(EntityCollisionContext context) {
        return this.predicate.test(context);
    }

    public Optional<Component> getDescription() {
        if (this.description != null) {
            return Optional.of(this.description);
        }
        return Optional.empty();
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    @Override
    public Vector2i getIconSize() {
        return new Vector2i(32, 32);
    }

    @Override
    public Vector2i getRenderSize() {
        return new Vector2i(16, 16);
    }

    @Override
    public Vector2i getTexturePosition() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE, PLAYERS_PASS -> new Vector2i(0, 0);
            case PLAYERS_BLOCK -> new Vector2i(0, 32);
            case MOBS_PASS -> new Vector2i(32, 0);
            case MOBS_BLOCK -> new Vector2i(32, 32);
            case ANIMALS_PASS -> new Vector2i(64, 0);
            case ANIMALS_BLOCK -> new Vector2i(64, 32);
        };
    }

    @Override
    public boolean shouldRender() {
        return this != NONE;
    }

    public String shortName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> "";
            case PLAYERS_PASS -> "p";
            case PLAYERS_BLOCK -> "np";
            case MOBS_PASS -> "m";
            case MOBS_BLOCK -> "nm";
            case ANIMALS_PASS -> "a";
            case ANIMALS_BLOCK -> "na";
        };
    }

    @Nullable
    public static GlassCollisionPredicate fromToken(Item token) {
        if (token == EIOItems.PLAYER_TOKEN.get()) {
            return PLAYERS_PASS;
        }
        if (token == EIOItems.ANIMAL_TOKEN.get()) {
            return ANIMALS_PASS;
        }
        if (token == EIOItems.MONSTER_TOKEN.get()) {
            return MOBS_PASS;
        }
        return null;
    }

    public static GlassCollisionPredicate invert(GlassCollisionPredicate predicate) {
        return switch (predicate) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> NONE;
            case MOBS_PASS -> MOBS_BLOCK;
            case MOBS_BLOCK -> MOBS_PASS;
            case ANIMALS_BLOCK -> ANIMALS_PASS;
            case ANIMALS_PASS -> ANIMALS_BLOCK;
            case PLAYERS_BLOCK -> PLAYERS_PASS;
            case PLAYERS_PASS -> PLAYERS_BLOCK;
        };
    }

    static {
        TEXTURE = EnderIO.loc("textures/item/overlay/fused_quartz_hitbox_overlay.png");
    }
}

