/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;

public interface Packet {
    public boolean isValid(NetworkEvent.Context var1);

    public void handle(NetworkEvent.Context var1);

    public static void logPacketError(NetworkEvent.Context context, String error, Packet packet) {
        Object sender = context.getDirection() == NetworkDirection.PLAY_TO_CLIENT ? "the server" : context.getSender().m_7755_().m_214077_() + " with IP-Address " + context.getSender().m_9239_();
        LogManager.getLogger().warn("Packet {} from {}: {}", packet.getClass(), sender, (Object)error);
    }

    public static abstract class PacketHandler<MSG extends Packet>
    implements BiConsumer<MSG, Supplier<NetworkEvent.Context>> {
        public abstract MSG fromNetwork(FriendlyByteBuf var1);

        public abstract void toNetwork(MSG var1, FriendlyByteBuf var2);

        @Override
        public void accept(MSG msg, Supplier<NetworkEvent.Context> context) {
            NetworkEvent.Context ctx = context.get();
            if (msg.isValid(context.get())) {
                ctx.enqueueWork(() -> msg.handle(ctx));
            } else {
                Packet.logPacketError(ctx, "didn't pass check and is invalid", msg);
            }
            context.get().setPacketHandled(true);
        }

        public abstract Optional<NetworkDirection> getDirection();
    }
}

