/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.slot.FluidStackNetworkDataSlot;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.fluid.IFluidItemInteractive;
import com.enderio.machines.common.io.fluid.MachineFluidHandler;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.fluid.MachineTankLayout;
import com.enderio.machines.common.io.fluid.TankAccess;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.FluidTankMenu;
import com.enderio.machines.common.recipe.TankRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public abstract class FluidTankBlockEntity
extends MachineBlockEntity
implements IFluidItemInteractive {
    private static final TankAccess TANK = new TankAccess();
    private final TankRecipe.Container container;
    private Optional<TankRecipe> currentRecipe = Optional.empty();
    public static final SingleSlotAccess FLUID_FILL_INPUT = new SingleSlotAccess();
    public static final SingleSlotAccess FLUID_FILL_OUTPUT = new SingleSlotAccess();
    public static final SingleSlotAccess FLUID_DRAIN_INPUT = new SingleSlotAccess();
    public static final SingleSlotAccess FLUID_DRAIN_OUTPUT = new SingleSlotAccess();

    public FluidTankBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.addDataSlot(new FluidStackNetworkDataSlot(() -> TANK.getFluid(this), f -> TANK.setFluid(this, (FluidStack)f)));
        this.container = new TankRecipe.Container((IItemHandlerModifiable)this.getInventoryNN(), () -> TANK.getTank(this));
    }

    @Override
    public void serverTick() {
        if (this.canActSlow()) {
            this.fillInternal();
            this.drainInternal();
            this.tryTankRecipe();
            this.tryMendTool();
        }
        super.serverTick();
    }

    public boolean acceptItemFill(ItemStack item) {
        List allRecipes;
        Optional fluidHandlerCap = item.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (fluidHandlerCap.isPresent()) {
            return true;
        }
        return this.f_58857_ != null && (allRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)MachineRecipes.TANK.type().get())).stream().anyMatch(recipe -> recipe.isEmptying() && recipe.getInput().test(item));
    }

    public boolean acceptItemDrain(ItemStack item) {
        List allRecipes;
        Optional fluidHandlerCap = item.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (fluidHandlerCap.isPresent()) {
            return true;
        }
        FluidStack fluid = TANK.getFluid(this);
        if (item.m_41763_() && !fluid.isEmpty() && fluid.getFluid().m_205067_(EIOTags.Fluids.EXPERIENCE) && item.getEnchantmentLevel(Enchantments.f_44962_) > 0) {
            return true;
        }
        return this.f_58857_ != null && (allRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)MachineRecipes.TANK.type().get())).stream().anyMatch(recipe -> !recipe.isEmptying() && recipe.getInput().test(item));
    }

    @Override
    public MachineInventoryLayout createInventoryLayout() {
        return MachineInventoryLayout.builder().inputSlot((slot, stack) -> this.acceptItemFill((ItemStack)stack)).slotAccess(FLUID_FILL_INPUT).outputSlot().slotAccess(FLUID_FILL_OUTPUT).inputSlot((slot, stack) -> this.acceptItemDrain((ItemStack)stack)).slotAccess(FLUID_DRAIN_INPUT).outputSlot().slotAccess(FLUID_DRAIN_OUTPUT).build();
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.currentRecipe = this.f_58857_.m_7465_().m_44015_((RecipeType)MachineRecipes.TANK.type().get(), (Container)this.container, this.f_58857_);
        }
    }

    @Override
    @Nullable
    protected MachineFluidHandler createFluidHandler(MachineTankLayout layout) {
        return new MachineFluidHandler(this.getIOConfig(), this.getTankLayout()){

            @Override
            protected void onContentsChanged(int slot) {
                FluidTankBlockEntity.this.onTankContentsChanged();
                FluidTankBlockEntity.this.updateMachineState(MachineState.EMPTY_TANK, TANK.getFluidAmount(this) <= 0);
                super.onContentsChanged(slot);
            }
        };
    }

    public MachineFluidTank getFluidTank() {
        return TANK.getTank(this);
    }

    private void fillInternal() {
        ItemStack inputItem = FLUID_FILL_INPUT.getItemStack(this);
        ItemStack outputItem = FLUID_FILL_OUTPUT.getItemStack(this);
        if (!inputItem.m_41619_()) {
            Item item = inputItem.m_41720_();
            if (item instanceof BucketItem) {
                int filled;
                BucketItem filledBucket = (BucketItem)item;
                if ((outputItem.m_41619_() || outputItem.m_41720_() == Items.f_42446_ && outputItem.m_41613_() < outputItem.m_41741_()) && (filled = TANK.fill(this, new FluidStack(filledBucket.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE)) == 1000) {
                    TANK.fill(this, new FluidStack(filledBucket.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                    inputItem.m_41774_(1);
                    FLUID_FILL_OUTPUT.insertItem(this, Items.f_42446_.m_7968_(), false);
                }
            } else {
                IFluidHandlerItem itemFluid;
                int filled;
                Optional fluidHandlerCap = inputItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
                if (fluidHandlerCap.isPresent() && outputItem.m_41619_() && (filled = this.moveFluids((IFluidHandler)(itemFluid = (IFluidHandlerItem)fluidHandlerCap.get()), this.getFluidHandler(), TANK.getCapacity(this))) > 0) {
                    FLUID_FILL_OUTPUT.setStackInSlot(this, itemFluid.getContainer());
                    FLUID_FILL_INPUT.setStackInSlot(this, ItemStack.f_41583_);
                }
            }
        }
    }

    @Override
    public InteractionResult onBlockEntityUsed(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.handleFluidItemInteraction(player, hand, stack, this, TANK)) {
            player.m_150109_().m_6596_();
            return InteractionResult.CONSUME;
        }
        return super.onBlockEntityUsed(state, level, pos, player, hand, hit);
    }

    private void drainInternal() {
        ItemStack inputItem = FLUID_DRAIN_INPUT.getItemStack(this);
        ItemStack outputItem = FLUID_DRAIN_OUTPUT.getItemStack(this);
        if (!inputItem.m_41619_()) {
            if (inputItem.m_41720_() == Items.f_42446_) {
                FluidStack stack;
                if (!TANK.getFluid(this).isEmpty() && (stack = TANK.drain((MachineBlockEntity)this, 1000, IFluidHandler.FluidAction.SIMULATE)).getAmount() == 1000 && (outputItem.m_41619_() || outputItem.m_41720_() == stack.getFluid().m_6859_() && outputItem.m_41613_() < outputItem.m_41741_())) {
                    TANK.drain((MachineBlockEntity)this, 1000, IFluidHandler.FluidAction.EXECUTE);
                    inputItem.m_41774_(1);
                    if (outputItem.m_41619_()) {
                        FLUID_DRAIN_OUTPUT.setStackInSlot(this, stack.getFluid().m_6859_().m_7968_());
                    } else {
                        outputItem.m_41769_(1);
                    }
                }
            } else {
                Optional fluidHandlerCap = inputItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
                if (fluidHandlerCap.isPresent() && outputItem.m_41619_()) {
                    IFluidHandlerItem itemFluid = (IFluidHandlerItem)fluidHandlerCap.get();
                    int filled = this.moveFluids(this.getFluidHandler(), (IFluidHandler)itemFluid, TANK.getFluidAmount(this));
                    if (filled > 0) {
                        FLUID_DRAIN_OUTPUT.setStackInSlot(this, itemFluid.getContainer());
                        FLUID_DRAIN_INPUT.setStackInSlot(this, ItemStack.f_41583_);
                    }
                }
            }
        }
    }

    private void tryTankRecipe() {
        this.currentRecipe.ifPresent(recipe -> {
            ItemStack recipeOutput = recipe.getOutput();
            if (recipe.isEmptying()) {
                ItemStack outputStack = FLUID_FILL_OUTPUT.getItemStack(this);
                if (outputStack.m_41619_() || outputStack.m_150930_(recipeOutput.m_41720_()) && outputStack.m_41613_() < outputStack.m_41741_()) {
                    FLUID_FILL_INPUT.getItemStack(this).m_41774_(1);
                    TANK.fill(this, recipe.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                    if (outputStack.m_41619_()) {
                        FLUID_FILL_OUTPUT.setStackInSlot(this, recipeOutput);
                    } else {
                        FLUID_FILL_OUTPUT.getItemStack(this).m_41769_(1);
                    }
                }
            } else {
                ItemStack outputStack = FLUID_DRAIN_OUTPUT.getItemStack(this);
                if (outputStack.m_41619_() || outputStack.m_150930_(recipeOutput.m_41720_()) && outputStack.m_41613_() < outputStack.m_41741_()) {
                    FLUID_DRAIN_INPUT.getItemStack(this).m_41774_(1);
                    TANK.drain((MachineBlockEntity)this, recipe.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                    if (outputStack.m_41619_()) {
                        FLUID_DRAIN_OUTPUT.setStackInSlot(this, recipeOutput);
                    } else {
                        FLUID_DRAIN_OUTPUT.getItemStack(this).m_41769_(1);
                    }
                }
            }
        });
    }

    private void tryMendTool() {
        ItemStack tool;
        FluidStack fluid = TANK.getFluid(this);
        if (!fluid.isEmpty() && fluid.getFluid().m_205067_(EIOTags.Fluids.EXPERIENCE) && (tool = FLUID_DRAIN_INPUT.getItemStack(this)).m_41763_() && tool.getEnchantmentLevel(Enchantments.f_44962_) > 0) {
            ItemStack repairedTool = tool.m_41777_();
            int damage = tool.m_41773_();
            int xpAmount = (int)Math.floor((float)damage / tool.getXpRepairRatio());
            int fluidAmount = xpAmount * ExperienceUtil.EXP_TO_FLUID;
            FluidStack drainedXp = TANK.drain((MachineBlockEntity)this, fluidAmount, IFluidHandler.FluidAction.EXECUTE);
            int repairAmount = (int)Math.floor((float)drainedXp.getAmount() * tool.getXpRepairRatio() / (float)ExperienceUtil.EXP_TO_FLUID);
            repairedTool.m_41721_(Math.max(0, damage - repairAmount));
            FLUID_DRAIN_INPUT.setStackInSlot(this, ItemStack.f_41583_);
            FLUID_DRAIN_OUTPUT.setStackInSlot(this, repairedTool);
        }
    }

    private void onTankContentsChanged() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.m_5776_()) {
                this.currentRecipe = this.f_58857_.m_7465_().m_44015_((RecipeType)MachineRecipes.TANK.type().get(), (Container)this.container, this.f_58857_);
            }
            this.f_58857_.m_5518_().m_7174_(this.f_58858_);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new FluidTankMenu(this, pInventory, pContainerId);
    }

    @Override
    public int getLightEmission() {
        return TANK.getFluid(this).getFluid().getFluidType().getLightLevel();
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
    }

    public static class Enhanced
    extends FluidTankBlockEntity {
        public static final int CAPACITY = 32000;

        public Enhanced(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
            super(type, worldPosition, blockState);
        }

        @Override
        @Nullable
        public MachineTankLayout getTankLayout() {
            return new MachineTankLayout.Builder().tank(TANK, 32000).build();
        }
    }

    public static class Standard
    extends FluidTankBlockEntity {
        public static final int CAPACITY = 16000;

        public Standard(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
            super(type, worldPosition, blockState);
        }

        @Override
        @Nullable
        public MachineTankLayout getTankLayout() {
            return new MachineTankLayout.Builder().tank(TANK, 16000).build();
        }
    }
}

