/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.AbilityStoreCapabilityProvider;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStoreRegistryAccess;
import org.cyclops.everlastingabilities.core.helper.WorldHelpers;

public class ItemStackMutableAbilityStore
implements IMutableAbilityStoreRegistryAccess {
    private static final String NBT_STORE = "everlastingabilities:abilityStoreStack";
    private final ItemStack itemStack;
    @Nullable
    private RegistryAccess registryAccess;

    public ItemStackMutableAbilityStore(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void setRegistryAccess(RegistryAccess registryAccess) {
        this.registryAccess = registryAccess;
    }

    protected Registry<IAbilityType> getRegistry() {
        return AbilityHelpers.getRegistry(this.registryAccess != null ? this.registryAccess : WorldHelpers.getRegistryAccess());
    }

    protected IMutableAbilityStore getInnerStore() {
        DefaultMutableAbilityStore store = new DefaultMutableAbilityStore();
        CompoundTag root = this.itemStack.m_41784_();
        if (!root.m_128441_(NBT_STORE)) {
            root.m_128365_(NBT_STORE, (Tag)new ListTag());
        }
        Tag nbt = root.m_128423_(NBT_STORE);
        AbilityStoreCapabilityProvider.deserializeNBTStatic(this.getRegistry(), store, nbt);
        return store;
    }

    protected IMutableAbilityStore setInnerStore(IMutableAbilityStore store) {
        CompoundTag root = this.itemStack.m_41784_();
        Tag nbt = AbilityStoreCapabilityProvider.serializeNBTStatic(this.getRegistry(), store);
        root.m_128365_(NBT_STORE, nbt);
        return store;
    }

    @Override
    @NonNull
    public Ability addAbility(Ability ability, boolean doAdd) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.addAbility(ability, doAdd);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    @NonNull
    public Ability removeAbility(Ability ability, boolean doRemove) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.removeAbility(ability, doRemove);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public void setAbilities(Map<IAbilityType, Integer> abilityTypes) {
        IMutableAbilityStore store = this.getInnerStore();
        store.setAbilities(abilityTypes);
        this.setInnerStore(store);
    }

    @Override
    public boolean hasAbilityType(IAbilityType abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.hasAbilityType(abilityType);
    }

    @Override
    public Collection<IAbilityType> getAbilityTypes() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilityTypes();
    }

    @Override
    public Collection<Ability> getAbilities() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilities();
    }

    @Override
    public Map<IAbilityType, Integer> getAbilitiesRaw() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilitiesRaw();
    }

    @Override
    public Ability getAbility(IAbilityType abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbility(abilityType);
    }
}

