/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;
import org.cyclops.everlastingabilities.network.packet.MoveAbilityPacket;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ContainerScreenAbilityContainer
extends ContainerScreenExtended<ContainerAbilityContainer> {
    private static final ResourceLocation RES_ITEM_GLINT = ItemRenderer.f_273833_;
    protected static final int ABILITY_LIST_SIZE = 6;
    protected static final int ABILITY_BOX_HEIGHT = 18;
    protected static final int ABILITY_BOX_WIDTH = 63;
    private final Player player;
    protected int startIndexPlayer = 0;
    protected int startIndexItem = 0;
    protected int absoluteSelectedIndexPlayer = -1;
    protected int absoluteSelectedIndexItem = -1;
    protected ButtonArrow buttonUp1;
    protected ButtonArrow buttonDown1;
    protected ButtonArrow buttonUp2;
    protected ButtonArrow buttonDown2;
    protected ButtonArrow buttonLeft;
    protected ButtonArrow buttonRight;

    public ContainerScreenAbilityContainer(ContainerAbilityContainer container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.f_35978_;
        container.setGui(this);
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("everlastingabilities", "textures/gui/ability_totem.png");
    }

    public void m_7856_() {
        super.m_7856_();
        this.buttonUp1 = new ButtonArrow(this.f_97735_ + 73, this.f_97736_ + 83, (Component)Component.m_237115_((String)"gui.cyclopscore.up"), button -> {
            if (this.startIndexPlayer > 0) {
                --this.startIndexPlayer;
            }
        }, ButtonArrow.Direction.NORTH);
        this.m_142416_((GuiEventListener)this.buttonUp1);
        this.buttonDown1 = new ButtonArrow(this.f_97735_ + 73, this.f_97736_ + 174, (Component)Component.m_237115_((String)"gui.cyclopscore.down"), button -> {
            if (this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount())) {
                ++this.startIndexPlayer;
            }
        }, ButtonArrow.Direction.SOUTH);
        this.m_142416_((GuiEventListener)this.buttonDown1);
        this.buttonUp2 = new ButtonArrow(this.f_97735_ + 88, this.f_97736_ + 83, (Component)Component.m_237115_((String)"gui.cyclopscore.up"), button -> {
            if (this.startIndexItem > 0) {
                --this.startIndexItem;
            }
        }, ButtonArrow.Direction.NORTH);
        this.m_142416_((GuiEventListener)this.buttonUp2);
        this.buttonDown2 = new ButtonArrow(this.f_97735_ + 88, this.f_97736_ + 174, (Component)Component.m_237115_((String)"gui.cyclopscore.down"), button -> {
            if (this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount())) {
                ++this.startIndexItem;
            }
        }, ButtonArrow.Direction.SOUTH);
        this.m_142416_((GuiEventListener)this.buttonDown2);
        Registry<IAbilityType> registry = AbilityHelpers.getRegistry(this.player.m_9236_().m_9598_());
        this.buttonLeft = new ButtonArrow(this.f_97735_ + 76, this.f_97736_ + 130, (Component)Component.m_237115_((String)"gui.cyclopscore.left"), button -> {
            if (this.canMoveToPlayer()) {
                EverlastingAbilities._instance.getPacketHandler().sendToServer((PacketBase)new MoveAbilityPacket(registry, this.getSelectedItemAbilitySingle(), MoveAbilityPacket.Movement.TO_PLAYER));
                this.moveToPlayer();
            }
        }, ButtonArrow.Direction.WEST);
        this.m_142416_((GuiEventListener)this.buttonLeft);
        this.buttonRight = new ButtonArrow(this.f_97735_ + 90, this.f_97736_ + 130, (Component)Component.m_237115_((String)"gui.cyclopscore.right"), button -> {
            if (this.canMoveFromPlayer()) {
                EverlastingAbilities._instance.getPacketHandler().sendToServer((PacketBase)new MoveAbilityPacket(registry, this.getSelectedPlayerAbilitySingle(), MoveAbilityPacket.Movement.FROM_PLAYER));
                this.moveFromPlayer();
            }
        }, ButtonArrow.Direction.EAST);
        this.m_142416_((GuiEventListener)this.buttonRight);
    }

    protected int getBaseYSize() {
        return 219;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((ContainerAbilityContainer)this.m_6262_()).getItemStack(this.player) == null) {
            return;
        }
        guiGraphics.m_280488_(this.f_96547_, this.player.m_5446_().getString(), 8, 6, -1);
        guiGraphics.m_280648_(this.f_96547_, ((ContainerAbilityContainer)this.m_6262_()).getItemStack(this.player).m_41786_().m_7532_(), 102, 6, -1);
        this.drawAbilitiesTooltip(guiGraphics, 8, 83, this.getPlayerAbilities(), this.startIndexPlayer, mouseX, mouseY);
        this.drawAbilitiesTooltip(guiGraphics, 105, 83, this.getItemAbilities(), this.startIndexItem, mouseX, mouseY);
    }

    protected List<Ability> getPlayerAbilities() {
        List<Ability> abilities = ((ContainerAbilityContainer)this.m_6262_()).getPlayerAbilities();
        Collections.sort(abilities);
        return abilities;
    }

    protected List<Ability> getItemAbilities() {
        List<Ability> abilities = ((ContainerAbilityContainer)this.m_6262_()).getItemAbilities();
        Collections.sort(abilities);
        return abilities;
    }

    protected IMutableAbilityStore getPlayerAbilityStore() {
        return (IMutableAbilityStore)((ContainerAbilityContainer)this.m_6262_()).getPlayerAbilityStore().orElse(null);
    }

    protected IMutableAbilityStore getItemAbilityStore() {
        return (IMutableAbilityStore)((ContainerAbilityContainer)this.m_6262_()).getItemAbilityStore().orElse(null);
    }

    protected int getPlayerAbilitiesCount() {
        return this.getPlayerAbilities().size();
    }

    protected int getItemAbilitiesCount() {
        return this.getItemAbilities().size();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        if (((ContainerAbilityContainer)this.m_6262_()).getItemStack(this.player) == null) {
            return;
        }
        if (this.buttonUp1 != null) {
            this.buttonUp1.f_93623_ = this.startIndexPlayer > 0;
            this.buttonDown1.f_93623_ = this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount());
            this.buttonUp2.f_93623_ = this.startIndexItem > 0;
            this.buttonDown2.f_93623_ = this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount());
            this.buttonLeft.f_93623_ = this.canMoveToPlayer();
            this.buttonRight.f_93623_ = this.canMoveFromPlayer();
            this.buttonRight.f_93623_ = this.canMoveFromPlayerByItem();
        }
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.drawFancyBackground(guiGraphics, i + 8, j + 17, 66, 61, this.getPlayerAbilityStore());
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(i + 41), (int)(j + 75), (int)30, (float)((float)(i + 41) - (float)mouseX), (float)((float)(j + 76 - 50) - (float)mouseY), (LivingEntity)this.getMinecraft().f_91074_);
        this.drawXp(guiGraphics, i + 67, j + 70);
        RenderHelpers.drawScaledCenteredString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)this.f_96547_, (String)("" + this.player.f_36079_), (int)(i + 62), (int)(j + 73), (int)0, (float)0.5f, (int)Helpers.RGBToInt((int)40, (int)215, (int)40), (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        this.drawFancyBackground(guiGraphics, i + 102, j + 17, 66, 61, this.getItemAbilityStore());
        ContainerScreenAbilityContainer.drawItemOnScreen(i + 134, j + 46, 50, (float)(i + 134) - (float)mouseX, (float)(j + 46 - 30) - (float)mouseY, ((ContainerAbilityContainer)this.m_6262_()).getItemStack((Player)this.getMinecraft().f_91074_));
        this.drawAbilities(guiGraphics, this.f_97735_ + 8, this.f_97736_ + 83, this.getPlayerAbilities(), this.startIndexPlayer, Integer.MAX_VALUE, this.absoluteSelectedIndexPlayer, mouseX, mouseY, this.canMoveFromPlayerByItem());
        this.drawAbilities(guiGraphics, this.f_97735_ + 105, this.f_97736_ + 83, this.getItemAbilities(), this.startIndexItem, this.player.f_36079_, this.absoluteSelectedIndexItem, mouseX, mouseY, true);
    }

    public void drawFancyBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, IAbilityStore abilityStore) {
        RenderType rendertype = Sheets.m_110791_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexconsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferSource, (RenderType)rendertype, (boolean)true, (boolean)true);
        int r = 140;
        int g = 140;
        int b = 140;
        if (abilityStore != null) {
            if (abilityStore.getAbilityTypes().isEmpty()) {
                return;
            }
            Triple<Integer, Integer, Integer> color = AbilityHelpers.getAverageRarityColor(abilityStore);
            r = (Integer)color.getLeft();
            g = (Integer)color.getMiddle();
            b = (Integer)color.getRight();
        }
        float f = (float)(Util.m_137550_() % 9000L) / 9000.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_COLOR);
        this.drawTexturedModalRectColor(guiGraphics, vertexconsumer, x, y, (int)(0.0f + f * 256.0f), 0, width, height, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
        this.drawTexturedModalRectColor(guiGraphics, vertexconsumer, x, y, (int)(0.0f + f * 150.0f), (int)(0.0f + f * 256.0f), width, height, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawXp(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(this.texture, x, y, 0, 219, 5, 5);
    }

    private void drawAbilities(GuiGraphics guiGraphics, int x, int y, List<Ability> abilities, int startIndex, int playerXp, int currentSelectedIndex, int mouseX, int mouseY, boolean canEdit) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            Ability ability = abilities.get(i + startIndex);
            if (canEdit) {
                boolean showActive;
                boolean active = currentSelectedIndex == i + startIndex;
                boolean bl = showActive = active || this.isPointInRegion(new Rectangle(x - this.f_97735_, boxY - this.f_97736_, 63, 18), new Point(mouseX, mouseY));
                if (showActive) {
                    this.drawFancyBackground(guiGraphics, x, boxY - 1, 63, 18, null);
                }
            }
            RenderHelpers.drawScaledCenteredString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)this.f_96547_, (String)Component.m_237115_((String)ability.getAbilityType().getTranslationKey()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ability.getAbilityType().getRarity().f_43022_))).getString(), (int)(x + 27), (int)(boxY + 7), (int)0, (float)1.0f, (int)50, (int)-1, (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
            RenderHelpers.drawScaledCenteredString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)this.f_96547_, (String)("" + ability.getLevel()), (int)(x + 58), (int)(boxY + 5), (int)0, (float)0.8f, (int)-1, (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
            int requiredXp = ability.getAbilityType().getXpPerLevelScaled();
            if (playerXp < requiredXp) {
                RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.drawXp(guiGraphics, x + 57, boxY + 10);
            RenderHelpers.drawScaledCenteredString((PoseStack)guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), (Font)this.f_96547_, (String)("" + requiredXp), (int)(x + 53), (int)(boxY + 13), (int)0, (float)0.5f, (int)Helpers.RGBToInt((int)40, (int)215, (int)40), (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawAbilitiesTooltip(GuiGraphics guiGraphics, int x, int y, List<Ability> abilities, int startIndex, int mouseX, int mouseY) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            if (!this.isPointInRegion(new Rectangle(x, boxY, 63, 18), new Point(mouseX, mouseY))) continue;
            Ability ability = abilities.get(i + startIndex);
            LinkedList lines = Lists.newLinkedList();
            lines.add(Component.m_237115_((String)ability.getAbilityType().getTranslationKey()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ability.getAbilityType().getRarity().f_43022_))));
            lines.add(Component.m_237110_((String)"general.everlastingabilities.level", (Object[])new Object[]{ability.getLevel(), ability.getAbilityType().getMaxLevel() == -1 ? "Inf" : Integer.valueOf(ability.getAbilityType().getMaxLevel())}));
            lines.add(Component.m_237115_((String)ability.getAbilityType().getUnlocalizedDescription()).m_6270_(Style.f_131099_.m_131152_(IInformationProvider.INFO_PREFIX_STYLES)));
            lines.add(Component.m_237110_((String)"general.everlastingabilities.xp", (Object[])new Object[]{ability.getAbilityType().getXpPerLevelScaled(), AbilityHelpers.getLevelForExperience(ability.getAbilityType().getXpPerLevelScaled())}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_GREEN))));
            if (!AbilityHelpers.PREDICATE_ABILITY_ENABLED.test(ability.getAbilityType())) {
                lines.add(Component.m_237115_((String)"general.everlastingabilities.disabled").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED)).m_131136_(Boolean.valueOf(true))));
            }
            this.drawTooltip(lines, guiGraphics.m_280168_(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public void drawTexturedModalRectColor(GuiGraphics guiGraphics, VertexConsumer vertexbuffer, int x, int y, int textureX, int textureY, int width, int height, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        guiGraphics.m_280218_(RES_ITEM_GLINT, x, y, textureX, textureY, width, height);
    }

    public static void drawItemOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, ItemStack itemStack) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_85837_((double)posX, (double)posY, 1050.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        posestack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternionf rotation = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf cameraOrientationY = Axis.f_252436_.m_252977_(-f * 40.0f);
        Quaternionf cameraOrientationX = Axis.f_252529_.m_252977_(f1 * 20.0f);
        rotation.mul((Quaternionfc)cameraOrientationY);
        rotation.mul((Quaternionfc)cameraOrientationX);
        posestack1.m_252781_(rotation);
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84931_();
        Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, posestack1, (MultiBufferSource)renderTypeBuffer, null, 0);
        Lighting.m_84930_();
        renderTypeBuffer.m_109911_();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        int newSelectedPlayer = this.canMoveFromPlayerByItem() ? this.clickAbilities(8, 83, this.getPlayerAbilities(), this.startIndexPlayer, this.absoluteSelectedIndexPlayer, mouseX, mouseY) : -2;
        int newSelectedItem = this.clickAbilities(105, 83, this.getItemAbilities(), this.startIndexItem, this.absoluteSelectedIndexItem, mouseX, mouseY);
        if (newSelectedPlayer >= -1) {
            this.absoluteSelectedIndexPlayer = newSelectedPlayer;
        }
        if (newSelectedItem >= -1) {
            this.absoluteSelectedIndexItem = newSelectedItem;
        }
        if (newSelectedPlayer < 0 && newSelectedItem < 0) {
            super.m_6375_(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (this.m_6774_(8, 83, 63, 108, mouseX, mouseY)) {
            if (scrollAmount > 0.0) {
                if (this.startIndexPlayer > 0) {
                    --this.startIndexPlayer;
                }
            } else if (scrollAmount < 0.0 && this.startIndexPlayer + 6 < Math.max(6, this.getPlayerAbilitiesCount())) {
                ++this.startIndexPlayer;
            }
            return true;
        }
        if (this.m_6774_(105, 83, 63, 108, mouseX, mouseY)) {
            if (scrollAmount > 0.0) {
                if (this.startIndexItem > 0) {
                    --this.startIndexItem;
                }
            } else if (scrollAmount < 0.0 && this.startIndexItem + 6 < Math.max(6, this.getItemAbilitiesCount())) {
                ++this.startIndexItem;
            }
            return true;
        }
        return false;
    }

    private int clickAbilities(int x, int y, List<Ability> abilities, int startIndex, int currentSelectedIndex, double mouseX, double mouseY) {
        int maxI = Math.min(6, abilities.size() - startIndex);
        for (int i = 0; i < maxI; ++i) {
            int boxY = y + i * 18;
            if (!this.isPointInRegion(new Rectangle(x, boxY, 63, 18), new Point((int)mouseX, (int)mouseY))) continue;
            int absoluteIndex = startIndex + i;
            if (currentSelectedIndex == absoluteIndex) {
                return -1;
            }
            return absoluteIndex;
        }
        return -2;
    }

    public Ability getSelectedPlayerAbilitySingle() {
        Ability ability = this.getSelectedPlayerAbility();
        if (!ability.isEmpty()) {
            ability = new Ability(ability.getAbilityType(), 1);
        }
        return ability;
    }

    public Ability getSelectedItemAbilitySingle() {
        Ability ability = this.getSelectedItemAbility();
        if (!ability.isEmpty()) {
            ability = new Ability(ability.getAbilityType(), 1);
        }
        return ability;
    }

    public Ability getSelectedPlayerAbility() {
        List<Ability> abilities = this.getPlayerAbilities();
        if (this.absoluteSelectedIndexPlayer >= 0 && this.absoluteSelectedIndexPlayer < abilities.size()) {
            return abilities.get(this.absoluteSelectedIndexPlayer);
        }
        return Ability.EMPTY;
    }

    public Ability getSelectedItemAbility() {
        List<Ability> abilities = this.getItemAbilities();
        if (this.absoluteSelectedIndexItem >= 0 && this.absoluteSelectedIndexItem < abilities.size()) {
            return abilities.get(this.absoluteSelectedIndexItem);
        }
        return Ability.EMPTY;
    }

    public boolean canMoveFromPlayer(Ability ability, Player player, IMutableAbilityStore target) {
        return !ability.isEmpty() && AbilityHelpers.canInsert(ability, target);
    }

    public boolean canMoveToPlayer(Ability ability, Player player) {
        return !ability.isEmpty() && AbilityHelpers.canInsertToPlayer(ability, player);
    }

    public boolean canMoveFromPlayerByItem() {
        return ((ItemGuiAbilityContainer)((ContainerAbilityContainer)this.m_6262_()).getItem()).canMoveFromPlayer();
    }

    public boolean canMoveFromPlayer() {
        if (!this.canMoveFromPlayerByItem()) {
            return false;
        }
        Ability playerAbility = this.getSelectedPlayerAbilitySingle();
        return this.canMoveFromPlayer(playerAbility, this.player, this.getItemAbilityStore());
    }

    public boolean canMoveToPlayer() {
        Ability itemAbility = this.getSelectedItemAbilitySingle();
        return this.canMoveToPlayer(itemAbility, this.player);
    }

    public void moveFromPlayer() {
        ((ContainerAbilityContainer)this.m_6262_()).moveFromPlayer(this.getSelectedPlayerAbilitySingle());
    }

    public void moveToPlayer() {
        ((ContainerAbilityContainer)this.m_6262_()).moveToPlayer(this.getSelectedItemAbilitySingle());
    }
}

