/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popup;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabMembers;
import sonar.fluxnetworks.register.ClientMessages;

public class PopupMemberEdit
extends GuiPopupCore<GuiTabMembers> {
    public SimpleButton mSetAsUser;
    public SimpleButton mSetAsAdmin;
    public SimpleButton mCancelMembership;
    public SimpleButton mTransferOwnership;
    public int mTransferOwnershipCount;

    public PopupMemberEdit(GuiTabMembers host) {
        super(host);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        boolean editPermission = ((GuiTabMembers)this.mHost).getAccessLevel().canEdit();
        boolean ownerPermission = ((GuiTabMembers)this.mHost).getAccessLevel().canDelete();
        AccessLevel targetAccess = ((GuiTabMembers)this.mHost).mSelectedMember.getAccessLevel();
        if (targetAccess != AccessLevel.OWNER && editPermission) {
            String text = FluxTranslate.SET_USER.get();
            int width = Math.max(64, this.f_96547_.m_92895_(text) + 4);
            this.mSetAsUser = new SimpleButton(this, this.f_97735_ + (this.f_97726_ - width) / 2, this.f_97736_ + 78, width, 12, text);
            this.mSetAsUser.setClickable(targetAccess == AccessLevel.BLOCKED || targetAccess == AccessLevel.SUPER_ADMIN || targetAccess == AccessLevel.ADMIN && ownerPermission);
            this.mButtons.add(this.mSetAsUser);
            text = FluxTranslate.SET_ADMIN.get();
            width = Math.max(64, this.f_96547_.m_92895_(text) + 4);
            this.mSetAsAdmin = new SimpleButton(this, this.f_97735_ + (this.f_97726_ - width) / 2, this.f_97736_ + 78 + 16, width, 12, text);
            this.mSetAsAdmin.setClickable(targetAccess == AccessLevel.USER && ownerPermission);
            this.mButtons.add(this.mSetAsAdmin);
            text = FluxTranslate.CANCEL_MEMBERSHIP.get();
            width = Math.max(64, this.f_96547_.m_92895_(text) + 4);
            this.mCancelMembership = new SimpleButton(this, this.f_97735_ + (this.f_97726_ - width) / 2, this.f_97736_ + 78 + 32, width, 12, text, -43691);
            this.mCancelMembership.setClickable(targetAccess == AccessLevel.USER || targetAccess == AccessLevel.ADMIN && ownerPermission);
            this.mButtons.add(this.mCancelMembership);
            text = FluxTranslate.TRANSFER_OWNERSHIP.get();
            width = Math.max(64, this.f_96547_.m_92895_(text) + 4);
            this.mTransferOwnership = new SimpleButton(this, this.f_97735_ + (this.f_97726_ - width) / 2, this.f_97736_ + 78 + 48, width, 12, text, -65281);
            this.mTransferOwnership.setClickable(false);
            this.mButtons.add(this.mTransferOwnership);
        }
    }

    @Override
    public void drawForegroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        gr.m_280137_(this.f_96547_, ChatFormatting.AQUA + ((GuiTabMembers)this.mHost).mSelectedMember.getCachedName(), this.f_97735_ + this.f_97726_ / 2, this.f_97736_ + 38, 0xFFFFFF);
        gr.m_280137_(this.f_96547_, ((GuiTabMembers)this.mHost).mSelectedMember.getAccessLevel().getFormattedName(), this.f_97735_ + this.f_97726_ / 2, this.f_97736_ + 48, 0xFFFFFF);
        String uuid = ((GuiTabMembers)this.mHost).mSelectedMember.getPlayerUUID().toString();
        gr.m_280168_().m_85836_();
        gr.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
        gr.m_280137_(this.f_96547_, "UUID: " + uuid.substring(0, 16), (int)((float)(this.f_97735_ + this.f_97726_ / 2) / 0.75f), (int)((float)(this.f_97736_ + 60) / 0.75f), 0xFFFFFF);
        gr.m_280137_(this.f_96547_, uuid.substring(16), (int)((float)(this.f_97735_ + this.f_97726_ / 2) / 0.75f), (int)((float)(this.f_97736_ + 68) / 0.75f), 0xFFFFFF);
        gr.m_280168_().m_85849_();
        if (this.mTransferOwnership != null && this.mTransferOwnership.isMouseHovered(mouseX, mouseY) && !this.mTransferOwnership.isClickable() && ((GuiTabMembers)this.mHost).mSelectedMember.getAccessLevel() != AccessLevel.BLOCKED && ((GuiTabMembers)this.mHost).getAccessLevel().canDelete()) {
            gr.m_280137_(this.f_96547_, FluxTranslate.DOUBLE_SHIFT.get(), this.mTransferOwnership.x + this.mTransferOwnership.width / 2, this.mTransferOwnership.y + 14, 0xFFFFFF);
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            byte type = 0;
            boolean send = true;
            if (button == this.mSetAsUser) {
                type = 1;
            } else if (button == this.mSetAsAdmin) {
                type = 2;
            } else if (button == this.mCancelMembership) {
                type = 3;
            } else if (button == this.mTransferOwnership) {
                type = 4;
            } else {
                send = false;
            }
            if (send) {
                ClientMessages.editMember(((GuiTabMembers)this.mHost).getToken(), ((GuiTabMembers)this.mHost).getNetwork(), ((GuiTabMembers)this.mHost).mSelectedMember.getPlayerUUID(), type);
                ((GuiTabMembers)this.mHost).closePopup();
            }
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.mTransferOwnership != null) {
            if ((modifiers & 1) != 0) {
                ++this.mTransferOwnershipCount;
                if (this.mTransferOwnershipCount > 1) {
                    this.mTransferOwnership.setClickable(((GuiTabMembers)this.mHost).getAccessLevel().canDelete() && ((GuiTabMembers)this.mHost).mSelectedMember.getAccessLevel() != AccessLevel.BLOCKED);
                }
            } else {
                this.mTransferOwnershipCount = 0;
                this.mTransferOwnership.setClickable(false);
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

