/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabEditAbstract;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabSettings
extends GuiTabEditAbstract {
    public SimpleButton mDelete;
    public SimpleButton mApply;
    public int mDeleteCount;

    public GuiTabSettings(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mSecurityLevel = this.getNetwork().getSecurityLevel();
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_SETTING;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid()) {
            if (this.mDelete.isMouseHovered(mouseX, mouseY)) {
                if (this.mDelete.isClickable()) {
                    gr.m_280137_(this.f_96547_, ChatFormatting.BOLD + FluxTranslate.DELETE_NETWORK.get(), this.mDelete.x + this.mDelete.width / 2, this.mDelete.y - 12, 0xFF0000);
                } else {
                    gr.m_280137_(this.f_96547_, FluxTranslate.DOUBLE_SHIFT.get(), this.mDelete.x + this.mDelete.width / 2, this.mDelete.y - 12, 0xFFFFFF);
                }
            }
        } else {
            this.renderNavigationPrompt(gr, FluxTranslate.ERROR_NO_SELECTED, EnumNavigationTab.TAB_SELECTION);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.getNetwork().isValid()) {
            this.mNetworkName.m_94144_(this.getNetwork().getNetworkName());
            this.mDelete = new SimpleButton(this, this.f_97735_ + this.f_97726_ / 2 - 12 - 48, this.f_97736_ + 150, 48, 12, FluxTranslate.DELETE.get(), -43691);
            this.mDelete.setClickable(false);
            this.mButtons.add(this.mDelete);
            this.mApply = new SimpleButton(this, this.f_97735_ + this.f_97726_ / 2 + 12, this.f_97736_ + 150, 48, 12, FluxTranslate.APPLY.get());
            this.mApply.setClickable(false);
            this.mButtons.add(this.mApply);
            boolean colorSet = false;
            for (int i = 0; i < EnumNetworkColor.VALUES.length; ++i) {
                EnumNetworkColor color = EnumNetworkColor.VALUES[i];
                ColorButton button = new ColorButton(this, this.f_97735_ + 48 + i % 7 * 16, this.f_97736_ + 87 + i / 7 * 16, color.getRGB());
                if (!colorSet && color.getRGB() == this.getNetwork().getNetworkColor()) {
                    this.mColorButton = button;
                    button.setSelected(true);
                    colorSet = true;
                }
                this.mButtons.add(button);
            }
            if (!colorSet) {
                ColorButton button;
                this.mColorButton = button = new ColorButton(this, this.f_97735_ + 32, this.f_97736_ + 107, this.getNetwork().getNetworkColor());
                button.setSelected(true);
                this.mButtons.add(button);
            }
        }
    }

    @Override
    public void onEditSettingsChanged() {
        if (this.mApply != null) {
            boolean clickable = true;
            if (this.getNetwork().getSecurityLevel() != SecurityLevel.ENCRYPTED && this.mSecurityLevel == SecurityLevel.ENCRYPTED) {
                clickable = !this.mPassword.m_94155_().isEmpty();
            }
            this.mApply.setClickable(clickable && !this.mNetworkName.m_94155_().isEmpty());
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (button == this.mApply) {
                ClientMessages.editNetwork(this.getToken(), this.getNetwork(), this.mNetworkName.m_94155_(), this.mColorButton.mColor, this.mSecurityLevel, this.mPassword.m_94155_());
                this.mApply.setClickable(false);
            } else if (button == this.mDelete) {
                ClientMessages.deleteNetwork(this.getToken(), this.getNetwork());
                this.mDeleteCount = 0;
                this.mDelete.setClickable(false);
            }
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (!this.getNetwork().isValid()) {
            return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_SELECTION);
        }
        return false;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.mDelete != null && this.m_7222_() == null) {
            if ((modifiers & 1) != 0) {
                ++this.mDeleteCount;
                if (this.mDeleteCount > 1) {
                    this.mDelete.setClickable(true);
                }
            } else {
                this.mDeleteCount = 0;
                this.mDelete.setClickable(false);
            }
        }
        return super.onKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code == 1) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
            return;
        }
        if (code == -1 && key == 2) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
        }
    }
}

