/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedBookshelfModel
extends FramedBlockModel {
    private final Predicate<Direction> frontFacePred;

    private FramedBookshelfModel(BlockState state, BakedModel baseModel, Predicate<Direction> frontFacePred) {
        super(state, baseModel);
        this.frontFacePred = frontFacePred;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir) || !this.frontFacePred.test(quadDir)) {
            return;
        }
        List<BakedQuad> quads = quadMap.get(quadDir);
        QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.0625f)).export(quads);
        QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).export(quads);
        QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(true, 0.0625f)).apply(Modifiers.cutSideUpDown(0.9375f)).export(quads);
        QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(false, 0.0625f)).apply(Modifiers.cutSideUpDown(0.9375f)).export(quads);
        QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(0.5625f)).apply(Modifiers.cutSideLeftRight(0.9375f)).export(quads);
    }

    @Override
    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelUtils.CUTOUT;
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData data, RenderType renderType) {
        if (renderType == RenderType.m_110463_()) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                quadMap.get(dir).addAll(this.baseModel.getQuads(state, dir, rand, data, renderType));
            }
        }
    }

    public static FramedBookshelfModel normal(BlockState state, BakedModel baseModel) {
        return new FramedBookshelfModel(state, baseModel, dir -> true);
    }

    public static FramedBookshelfModel chiseled(BlockState state, BakedModel baseModel) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return new FramedBookshelfModel(state, baseModel, arg_0 -> facing.equals(arg_0));
    }

    public static BlockState itemSourceNormal() {
        return ((Block)FBContent.BLOCK_FRAMED_BOOKSHELF.get()).m_49966_();
    }

    public static BlockState itemSourceChiseled() {
        return ((Block)FBContent.BLOCK_FRAMED_CHISELED_BOOKSHELF.get()).m_49966_();
    }
}

