/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.rail;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedFancyRailModel
extends FramedBlockModel {
    private static final int SLEEPER_COUNT = 4;
    private static final int SLEEPER_COUNT_CURVE = 3;
    private static final float SLEEPER_BASE_OFFSET = 0.0625f;
    private static final float SLEEPER_DIST = 0.25f;
    private static final float SLEEPER_DIST_CURVE = 0.375f;
    private static final float SLEEPER_WIDTH = 0.125f;
    private static final float SLEEPER_HEIGHT = 0.0625f;
    private static final float SLEEPER_DIAGONAL_OFFSET = 0.115625f;
    private static final Vector3f SCALE_X = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f SCALE_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3f[] SLOPE_ORIGINS = (Vector3f[])Util.m_137469_((Object)new Vector3f[4], arr -> {
        arr[Direction.NORTH.m_122416_()] = new Vector3f(0.0f, 0.0f, 1.0f);
        arr[Direction.EAST.m_122416_()] = new Vector3f(0.0f, 0.0f, 0.0f);
        arr[Direction.SOUTH.m_122416_()] = new Vector3f(0.0f, 0.0f, 0.0f);
        arr[Direction.WEST.m_122416_()] = new Vector3f(1.0f, 0.0f, 0.0f);
    });
    private final RailShape shape;
    private final Direction mainDir;
    private final Direction secDir;

    private FramedFancyRailModel(BlockState state, BakedModel baseModel, Property<RailShape> shapeProperty) {
        super(state, baseModel);
        this.shape = (RailShape)state.m_61143_(shapeProperty);
        this.mainDir = FramedFancyRailModel.getDirectionFromRailShape(this.shape);
        this.secDir = FramedFancyRailModel.getSecondaryDirectionFromRailShape(this.shape);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Pair<List<BakedQuad>, Direction> result = this.shape.m_61745_() ? FramedFancyRailModel.makeAscendingRailSleepers(quad, this.mainDir) : (this.shape == RailShape.NORTH_SOUTH || this.shape == RailShape.EAST_WEST ? FramedFancyRailModel.makeStraightRailSleepers(quad, this.mainDir) : FramedFancyRailModel.makeCurvedRailSleepers(quad, this.mainDir, this.secDir));
        quadMap.get(result.getSecond()).addAll((Collection)result.getFirst());
    }

    private static Pair<List<BakedQuad>, Direction> makeStraightRailSleepers(BakedQuad quad, Direction dir) {
        Direction targetDir;
        ArrayList result = new ArrayList(4);
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            targetDir = quadDir == Direction.UP ? null : quadDir;
            FramedFancyRailModel.forAllSleepers((i, distDir, distOpp) -> QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(dir, distDir)).apply(Modifiers.cutTopBottom(dir.m_122424_(), distOpp)).applyIf(Modifiers.setPosition(0.0625f), quadDir == Direction.UP).export(result::add));
        } else if (quadDir.m_122434_() == dir.m_122434_()) {
            targetDir = null;
            FramedFancyRailModel.forAllSleepers((i, distDir, distOpp) -> QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).apply(Modifiers.setPosition(distDir)).export(result::add));
        } else {
            targetDir = quadDir;
            FramedFancyRailModel.forAllSleepers((i, distDir, distOpp) -> QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).apply(Modifiers.cutSideLeftRight(dir, distDir)).apply(Modifiers.cutSideLeftRight(dir.m_122424_(), distOpp)).export(result::add));
        }
        return Pair.of(result, (Object)targetDir);
    }

    private static Pair<List<BakedQuad>, Direction> makeAscendingRailSleepers(BakedQuad quad, Direction dir) {
        Pair<List<BakedQuad>, Direction> result = FramedFancyRailModel.makeStraightRailSleepers(quad, dir);
        Direction.Axis axis = dir.m_122427_().m_122434_();
        Vector3f origin = SLOPE_ORIGINS[dir.m_122416_()];
        float angle = Utils.isPositive(dir) == Utils.isX(dir) ? 45.0f : -45.0f;
        Vector3f scaleVec = Utils.isX(dir) ? SCALE_X : SCALE_Z;
        List quads = (List)result.getFirst();
        for (BakedQuad resultQuad : quads) {
            QuadModifier.geometry(resultQuad).apply(Modifiers.rotate(axis, origin, angle, true, scaleVec)).modifyInPlace();
        }
        Direction targetDir = result.getSecond() == Direction.DOWN ? null : (Direction)result.getSecond();
        return Pair.of((Object)quads, (Object)targetDir);
    }

    private static Pair<List<BakedQuad>, Direction> makeCurvedRailSleepers(BakedQuad quad, Direction dir, Direction secDir) {
        Direction targetDir;
        ArrayList result = new ArrayList(3);
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            targetDir = quadDir == Direction.UP ? null : quadDir;
            FramedFancyRailModel.forAllSleepersCurve((i, distDir, distOpp) -> {
                boolean nonDiagUp = quadDir == Direction.UP && i != 1;
                float height = nonDiagUp ? 0.0615f : 0.0625f;
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(dir, distDir)).apply(Modifiers.cutTopBottom(dir.m_122424_(), distOpp)).applyIf(Modifiers.setPosition(height), quadDir == Direction.UP).applyIf(FramedFancyRailModel.rotateCurveSleeper(dir, secDir, i), i < 2).applyIf(Modifiers.offset(dir, 0.115625f), i == 1).applyIf(Modifiers.offset(secDir, 0.115625f), i == 1).export(result::add);
            });
        } else if (quadDir.m_122434_() == dir.m_122434_()) {
            targetDir = null;
            boolean inDir = quadDir == dir;
            FramedFancyRailModel.forAllSleepersCurve((i, distDir, distOpp) -> QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).apply(Modifiers.setPosition(inDir ? distDir : distOpp)).applyIf(FramedFancyRailModel.rotateCurveSleeper(dir, secDir, i), i < 2).applyIf(Modifiers.offset(dir, 0.115625f), i == 1).applyIf(Modifiers.offset(secDir, 0.115625f), i == 1).export(result::add));
        } else {
            targetDir = quadDir;
            FramedFancyRailModel.forAllSleepersCurve((i, distDir, distOpp) -> QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.0625f)).apply(Modifiers.cutSideLeftRight(dir, distDir)).apply(Modifiers.cutSideLeftRight(dir.m_122424_(), distOpp)).applyIf(FramedFancyRailModel.rotateCurveSleeper(dir, secDir, i), i < 2).applyIf(Modifiers.offset(dir, 0.115625f), i == 1).applyIf(Modifiers.offset(secDir, 0.115625f), i == 1).export(result::add));
        }
        return Pair.of(result, (Object)targetDir);
    }

    private static QuadModifier.Modifier rotateCurveSleeper(Direction dir, Direction secDir, int i) {
        float angle = 45.0f * (float)(2 - i);
        if (secDir == dir.m_122428_()) {
            angle *= -1.0f;
        }
        return Modifiers.rotateCentered(Direction.Axis.Y, angle, false);
    }

    private static void forAllSleepers(SleeperConsumer consumer) {
        for (int i = 0; i < 4; ++i) {
            float distDir = 0.0625f + (float)i * 0.25f + 0.125f;
            float distOpp = 1.0f - distDir + 0.125f;
            consumer.accept(i, distDir, distOpp);
        }
    }

    private static void forAllSleepersCurve(SleeperConsumer consumer) {
        for (int i = 0; i < 3; ++i) {
            float distDir = 0.0625f + (float)i * 0.375f + 0.125f;
            float distOpp = 1.0f - distDir + 0.125f;
            consumer.accept(i, distDir, distOpp);
        }
    }

    @Override
    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return this.baseModel.getRenderTypes(this.state, rand, extraData);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData data, RenderType renderType) {
        Utils.forAllDirections(dir -> ((List)quadMap.get(dir)).addAll(this.baseModel.getQuads(state, dir, rand, data, renderType)));
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }

    public static Direction getDirectionFromRailShape(RailShape shape) {
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case RailShape.NORTH_SOUTH -> Direction.NORTH;
            case RailShape.EAST_WEST -> Direction.EAST;
            case RailShape.ASCENDING_NORTH -> Direction.NORTH;
            case RailShape.ASCENDING_EAST -> Direction.EAST;
            case RailShape.ASCENDING_SOUTH -> Direction.SOUTH;
            case RailShape.ASCENDING_WEST -> Direction.WEST;
            case RailShape.NORTH_EAST, RailShape.NORTH_WEST -> Direction.NORTH;
            case RailShape.SOUTH_EAST, RailShape.SOUTH_WEST -> Direction.SOUTH;
        };
    }

    private static Direction getSecondaryDirectionFromRailShape(RailShape shape) {
        return switch (shape) {
            case RailShape.NORTH_EAST, RailShape.SOUTH_EAST -> Direction.EAST;
            case RailShape.NORTH_WEST, RailShape.SOUTH_WEST -> Direction.WEST;
            default -> null;
        };
    }

    public static FramedFancyRailModel normal(BlockState state, BakedModel baseModel) {
        return new FramedFancyRailModel(state, baseModel, (Property<RailShape>)BlockStateProperties.f_61403_);
    }

    public static FramedFancyRailModel straight(BlockState state, BakedModel baseModel) {
        return new FramedFancyRailModel(state, baseModel, (Property<RailShape>)BlockStateProperties.f_61404_);
    }

    @FunctionalInterface
    public static interface SleeperConsumer {
        public void accept(int var1, float var2, float var3);
    }
}

