/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeedge;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedSlopeEdgeModel
extends FramedBlockModel {
    private final Direction dir;
    private final SlopeType type;
    private final boolean altType;
    private final boolean ySlope;

    public FramedSlopeEdgeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        this.altType = (Boolean)state.m_61143_((Property)PropertyHolder.ALT_TYPE);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (this.altType) {
            if (this.type == SlopeType.HORIZONTAL) {
                if (quadDir == this.dir) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122428_(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                } else if (quadDir == this.dir.m_122428_()) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                } else if (!this.ySlope && quadDir == this.dir.m_122424_()) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122428_(), 0.5f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir.m_122424_(), 0.5f)).export(quadMap.get(null));
                } else if (this.ySlope && quadDir == this.dir.m_122427_()) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir.m_122427_(), 0.5f)).export(quadMap.get(null));
                } else if (Utils.isY(quadDir)) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 1.5f, 0.5f)).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).export(quadMap.get(quadDir));
                }
            } else {
                boolean top;
                boolean bl = top = this.type == SlopeType.TOP;
                if (quadDir == this.dir) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                } else if (!top && quadDir == Direction.DOWN || top && quadDir == Direction.UP) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                } else if (!this.ySlope && quadDir == this.dir.m_122424_()) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(this.dir.m_122424_(), 0.5f)).export(quadMap.get(null));
                } else if (this.ySlope && (!top && quadDir == Direction.UP || top && quadDir == Direction.DOWN)) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.m_122424_(), 45.0f)).apply(Modifiers.offset(top ? Direction.DOWN : Direction.UP, 0.5f)).export(quadMap.get(null));
                } else if (quadDir == this.dir.m_122427_() || quadDir == this.dir.m_122428_()) {
                    QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), top ? 1.5f : 0.5f, top ? 0.5f : 1.5f)).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).export(quadMap.get(quadDir));
                }
            }
            return;
        }
        if (this.type == SlopeType.HORIZONTAL) {
            if (!this.ySlope && quadDir == this.dir.m_122424_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122427_(), 0.5f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
            } else if (this.ySlope && quadDir == this.dir.m_122427_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.5f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir.m_122428_(), 0.5f)).export(quadMap.get(null));
            } else if (Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f, -0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122427_(), 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir.m_122428_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else {
            boolean top;
            boolean bl = top = this.type == SlopeType.TOP;
            if (!this.ySlope && quadDir == this.dir.m_122424_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
            } else if (this.ySlope && (!top && quadDir == Direction.UP || top && quadDir == Direction.DOWN)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.m_122424_(), 45.0f)).apply(Modifiers.offset(top ? Direction.UP : Direction.DOWN, 0.5f)).export(quadMap.get(null));
            } else if (quadDir == this.dir.m_122427_() || quadDir == this.dir.m_122428_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), top ? 0.5f : -0.5f, top ? -0.5f : 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).export(quadMap.get(quadDir));
            } else if (!top && quadDir == Direction.DOWN || top && quadDir == Direction.UP) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f)).export(quadMap.get(quadDir));
            }
        }
    }

    @Override
    public void applyInHandTransformation(PoseStack poseStack, ItemDisplayContext ctx) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }
}

